/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.util.List;
import org.drools.container.spring.beans.KnowledgeServiceBeanFactory;
import org.drools.container.spring.namespace.DefinitionParserHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class KnowledgeServiceDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String CAMEL_CONTEXT_ATTRIBUTE = "camelContext";
    private static final String EXECUTION_NODE_ID_ATTRIBUTE = "node";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String CONFIGURATION_REF_ELEMENT = "configuration-ref";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinition resourceDefinition;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(KnowledgeServiceBeanFactory.class);
        String nodeId = element.getAttribute(EXECUTION_NODE_ID_ATTRIBUTE);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), EXECUTION_NODE_ID_ATTRIBUTE, nodeId);
        factory.addPropertyValue("nodeId", (Object)nodeId);
        String camelContextId = element.getAttribute(CAMEL_CONTEXT_ATTRIBUTE);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), CAMEL_CONTEXT_ATTRIBUTE, camelContextId);
        factory.addPropertyReference(CAMEL_CONTEXT_ATTRIBUTE, camelContextId);
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)CONFIGURATION_ELEMENT);
        ManagedList configurations = null;
        if (childElements != null && !childElements.isEmpty()) {
            configurations = new ManagedList(childElements.size());
            for (Element childResource : childElements) {
                resourceDefinition = parserContext.getDelegate().parseCustomElement(childResource, (BeanDefinition)factory.getBeanDefinition());
                configurations.add((Object)resourceDefinition);
            }
        }
        if ((childElements = DomUtils.getChildElementsByTagName((Element)element, (String)CONFIGURATION_REF_ELEMENT)) != null && !childElements.isEmpty()) {
            if (configurations == null) {
                configurations = new ManagedList(childElements.size());
            }
            for (Element childResource : childElements) {
                resourceDefinition = parserContext.getDelegate().parseCustomElement(childResource, (BeanDefinition)factory.getBeanDefinition());
                configurations.add((Object)resourceDefinition);
            }
        }
        if (configurations != null) {
            factory.addPropertyValue("configurations", (Object)configurations);
        }
        return factory.getBeanDefinition();
    }
}

