/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import org.drools.container.spring.beans.StatefulKnowledgeSessionBeanFactory;
import org.drools.container.spring.beans.StatelessKnowledgeSessionBeanFactory;
import org.drools.container.spring.namespace.DefinitionParserHelper;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class KnowledgeSessionDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String EXECUTION_NODE_ATTRIBUTE = "node";
    private static final String KBASE_ATTRIBUTE = "kbase";
    private static final String TYPE_ATTRIBUTE = "type";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String name;
        BeanDefinitionBuilder factory;
        String kbase = element.getAttribute(KBASE_ATTRIBUTE);
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), KBASE_ATTRIBUTE, kbase);
        String sessionType = element.getAttribute(TYPE_ATTRIBUTE);
        if ("stateful".equals(sessionType)) {
            factory = BeanDefinitionBuilder.rootBeanDefinition(StatefulKnowledgeSessionBeanFactory.class);
        } else if ("stateless".equals(sessionType)) {
            factory = BeanDefinitionBuilder.rootBeanDefinition(StatelessKnowledgeSessionBeanFactory.class);
        } else {
            throw new IllegalArgumentException("Invalid value for type attribute: " + sessionType);
        }
        factory.addPropertyReference(KBASE_ATTRIBUTE, kbase);
        String node = element.getAttribute(EXECUTION_NODE_ATTRIBUTE);
        if (node != null && node.length() > 0) {
            factory.addPropertyReference(EXECUTION_NODE_ATTRIBUTE, node);
        }
        if ((name = element.getAttribute(NAME_ATTRIBUTE)) != null && name.length() > 0) {
            factory.addPropertyValue(NAME_ATTRIBUTE, (Object)name);
        }
        return factory.getBeanDefinition();
    }
}

