/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import org.drools.container.spring.beans.persistence.SpringTransactionSynchronizationAdapter;
import org.drools.persistence.session.TransactionManager;
import org.drools.persistence.session.TransactionSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DroolsSpringTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractPlatformTransactionManager ptm;
    TransactionDefinition td = new DefaultTransactionDefinition();
    TransactionStatus currentTransaction = null;
    private boolean localTransaction;

    public DroolsSpringTransactionManager(AbstractPlatformTransactionManager ptm) {
        this.ptm = ptm;
    }

    public void begin() {
        if (this.getStatus() == 3) {
            this.currentTransaction = this.ptm.getTransaction(this.td);
            this.localTransaction = true;
        } else {
            this.localTransaction = false;
        }
    }

    public void commit() {
        if (this.localTransaction) {
            this.localTransaction = false;
            this.ptm.commit(this.currentTransaction);
            this.currentTransaction = null;
        }
    }

    public void rollback() {
        if (this.localTransaction) {
            this.localTransaction = false;
            this.ptm.rollback(this.currentTransaction);
            this.currentTransaction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        if (this.ptm == null) {
            return 3;
        }
        this.logger.debug("Current TX name (According to TransactionSynchronizationManager) : " + TransactionSynchronizationManager.getCurrentTransactionName());
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionStatus transaction = null;
            try {
                if (this.currentTransaction == null) {
                    transaction = this.ptm.getTransaction(this.td);
                    if (transaction.isNewTransaction()) {
                        int n = 0;
                        return n;
                    }
                } else {
                    transaction = this.currentTransaction;
                }
                this.logger.debug("Current TX: " + transaction);
                if (transaction.isCompleted()) {
                    if (transaction.isRollbackOnly()) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                if (transaction.isRollbackOnly()) {
                    int n = 1;
                    return n;
                }
                int n = 4;
                return n;
            }
            finally {
                if (this.currentTransaction == null) {
                    this.ptm.commit(transaction);
                }
            }
        }
        return 3;
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        TransactionSynchronizationManager.registerSynchronization((org.springframework.transaction.support.TransactionSynchronization)new SpringTransactionSynchronizationAdapter(ts));
    }
}

