/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.container.spring.beans.StatefulKnowledgeSessionBeanFactory;
import org.drools.grid.Grid;
import org.drools.grid.SocketService;
import org.drools.grid.conf.GridPeerServiceConfiguration;
import org.drools.grid.conf.impl.GridPeerConfiguration;
import org.drools.grid.impl.GridImpl;
import org.drools.grid.impl.MultiplexSocketServerImpl;
import org.drools.grid.io.AcceptorFactoryService;
import org.drools.grid.io.impl.MultiplexSocketServiceCongifuration;
import org.drools.grid.remote.mina.MinaAcceptorFactoryService;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.CoreServicesLookupConfiguration;
import org.drools.grid.service.directory.impl.WhitePagesLocalConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBeanFactory
implements FactoryBean,
InitializingBean {
    private String id;
    private GridImpl grid;
    private Map coreServices;
    private WhitePages whitePages;
    private StatefulKnowledgeSessionBeanFactory.JpaConfiguration jpaConfiguration;
    private SocketServiceConfiguration socketServiceConfiguration;

    public Object getObject() throws Exception {
        return this.grid;
    }

    public Class<Grid> getObjectType() {
        return Grid.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.grid = new GridImpl(new HashMap());
        MultiplexSocketServiceCongifuration socketConf = null;
        if (this.coreServices == null) {
            this.coreServices = new HashMap();
        }
        GridPeerConfiguration conf = new GridPeerConfiguration();
        CoreServicesLookupConfiguration coreSeviceLookupConf = new CoreServicesLookupConfiguration(this.coreServices);
        conf.addConfiguration((GridPeerServiceConfiguration)coreSeviceLookupConf);
        if (this.whitePages != null) {
            WhitePagesLocalConfiguration wplConf = new WhitePagesLocalConfiguration();
            wplConf.setWhitePages(this.whitePages);
            conf.addConfiguration((GridPeerServiceConfiguration)wplConf);
        }
        conf.configure((Grid)this.grid);
        if (this.socketServiceConfiguration != null) {
            MinaAcceptorFactoryService acc = null;
            if ("mina".equals(this.socketServiceConfiguration.getAcceptor())) {
                acc = new MinaAcceptorFactoryService();
            }
            if (acc == null) {
                acc = new MinaAcceptorFactoryService();
            }
            socketConf = new MultiplexSocketServiceCongifuration((SocketService)new MultiplexSocketServerImpl(this.socketServiceConfiguration.getIp(), (AcceptorFactoryService)acc, SystemEventListenerFactory.getSystemEventListener(), (Grid)this.grid));
            for (String[] services : this.socketServiceConfiguration.getServices()) {
                Object service = this.grid.get(services[0].trim());
                if (service == null) {
                    throw new RuntimeException("Unable to configure socket. Service '" + services[0] + "' could not be found");
                }
                if ("auto".equals(services[1].trim())) continue;
                socketConf.addService(services[0].trim(), service, Integer.parseInt(services[1].trim()));
            }
            socketConf.configureService((Grid)this.grid);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public WhitePages getWhitePages() {
        return this.whitePages;
    }

    public void setWhitePages(WhitePages whitePages) {
        this.whitePages = whitePages;
    }

    public Map getCoreServices() {
        return this.coreServices;
    }

    public void setCoreServices(Map coreServices) {
        this.coreServices = coreServices;
    }

    public StatefulKnowledgeSessionBeanFactory.JpaConfiguration getJpaConfiguration() {
        return this.jpaConfiguration;
    }

    public void setJpaConfiguration(StatefulKnowledgeSessionBeanFactory.JpaConfiguration jpaConfiguration) {
        this.jpaConfiguration = jpaConfiguration;
    }

    public SocketServiceConfiguration getSocketServiceConfiguration() {
        return this.socketServiceConfiguration;
    }

    public void setSocketServiceConfiguration(SocketServiceConfiguration socketServiceConfiguration) {
        this.socketServiceConfiguration = socketServiceConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SocketServiceConfiguration {
        private String ip;
        private String acceptor;
        private List<String[]> services;

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getAcceptor() {
            return this.acceptor;
        }

        public void setAcceptor(String acceptor) {
            this.acceptor = acceptor;
        }

        public List<String[]> getServices() {
            if (this.services == null) {
                this.services = new ArrayList<String[]>();
            }
            return this.services;
        }

        public void setServices(List<String[]> services) {
            this.services = services;
        }
    }
}

