/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.io.impl.ChangeSetImpl;
import org.drools.io.internal.InternalResource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeAgentBeanFactory
implements FactoryBean,
InitializingBean {
    private KnowledgeBase kbase;
    private KnowledgeAgent kagent;
    private String id;
    private String newInstance;
    private String useKbaseClassloader = "false";
    private List<DroolsResourceAdapter> resources = Collections.emptyList();

    public Object getObject() throws Exception {
        return this.kagent;
    }

    public Class<KnowledgeAgent> getObjectType() {
        return KnowledgeAgent.class;
    }

    public void afterPropertiesSet() throws Exception {
        KnowledgeAgentConfiguration kagentConf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        if (this.kbase == null) {
            throw new RuntimeException("kagent must reference an existing kbase");
        }
        kagentConf.setProperty("drools.agent.newInstance", this.newInstance);
        kagentConf.setProperty("drools.agent.useKBaseClassLoaderForCompiling", this.useKbaseClassloader);
        this.kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)this.id, (KnowledgeBase)this.kbase, (KnowledgeAgentConfiguration)kagentConf);
        if (this.resources != null && !this.resources.isEmpty()) {
            ArrayList<InternalResource> rs = new ArrayList<InternalResource>();
            for (DroolsResourceAdapter res : this.resources) {
                InternalResource resource = (InternalResource)res.getDroolsResource();
                resource.setResourceType(res.getResourceType());
                if (res.getResourceConfiguration() != null) {
                    resource.setConfiguration(res.getResourceConfiguration());
                }
                rs.add(resource);
            }
            ChangeSetImpl changeSet = new ChangeSetImpl();
            changeSet.setResourcesAdded(rs);
            this.kagent.applyChangeSet((ChangeSet)changeSet);
        }
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public KnowledgeAgent getKagent() {
        return this.kagent;
    }

    public void setKagent(KnowledgeAgent kagent) {
        this.kagent = kagent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(String newInstance) {
        this.newInstance = newInstance;
    }

    public String getUseKbaseClassloader() {
        return this.useKbaseClassloader;
    }

    public void setUseKbaseClassloader(String useKbaseClassloader) {
        this.useKbaseClassloader = useKbaseClassloader;
    }

    public List<DroolsResourceAdapter> getResources() {
        return this.resources;
    }

    public void setResources(List<DroolsResourceAdapter> resources) {
        this.resources = resources;
    }

    public boolean isSingleton() {
        return false;
    }
}

