/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.command.Command;
import org.drools.container.spring.beans.AbstractKnowledgeSessionBeanFactory;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulKnowledgeSessionBeanFactory
extends AbstractKnowledgeSessionBeanFactory {
    private StatefulKnowledgeSession ksession;
    private JpaConfiguration jpaConfiguration;

    public Class<StatefulKnowledgeSession> getObjectType() {
        return StatefulKnowledgeSession.class;
    }

    public JpaConfiguration getJpaConfiguration() {
        return this.jpaConfiguration;
    }

    public void setJpaConfiguration(JpaConfiguration jpaConfiguration) {
        this.jpaConfiguration = jpaConfiguration;
    }

    @Override
    protected CommandExecutor getCommandExecutor() {
        return this.ksession;
    }

    @Override
    protected void internalAfterPropertiesSet() {
        if (this.getConf() != null && this.getWorkItems() != null && !this.getWorkItems().isEmpty()) {
            Map map = ((SessionConfiguration)this.getConf()).getWorkItemHandlers();
            map.putAll(this.getWorkItems());
        }
        if (this.jpaConfiguration != null) {
            Environment env = KnowledgeBaseFactory.newEnvironment();
            env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.jpaConfiguration.getEntityManagerFactory());
            env.set("drools.transaction.TransactionManager", (Object)this.jpaConfiguration.getPlatformTransactionManager());
            env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
            this.ksession = this.jpaConfiguration.getId() >= 0 ? JPAKnowledgeService.loadStatefulKnowledgeSession((int)this.jpaConfiguration.getId(), (KnowledgeBase)this.getKbase(), (KnowledgeSessionConfiguration)this.getConf(), (Environment)env) : JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)this.getKbase(), (KnowledgeSessionConfiguration)this.getConf(), (Environment)env);
        } else {
            this.ksession = this.getKbase().newStatefulKnowledgeSession(this.getConf(), null);
        }
        if (this.getBatch() != null && !this.getBatch().isEmpty()) {
            for (Command command : this.getBatch()) {
                this.ksession.execute(command);
            }
        }
        if (this.getNode() != null) {
            this.getNode().set(this.getName(), this.ksession);
        }
        for (AgendaEventListener agendaEventListener : this.getAgendaEventListeners()) {
            this.ksession.addEventListener(agendaEventListener);
        }
        for (ProcessEventListener processEventListener : this.getProcessEventListeners()) {
            this.ksession.addEventListener(processEventListener);
        }
        for (WorkingMemoryEventListener workingMemoryEventListener : this.getWorkingMemoryEventListeners()) {
            this.ksession.addEventListener(workingMemoryEventListener);
        }
    }

    public static class JpaConfiguration {
        private EntityManagerFactory emf;
        private PlatformTransactionManager tm;
        private int id = -1;

        public EntityManagerFactory getEntityManagerFactory() {
            return this.emf;
        }

        public void setEntityManagerFactory(EntityManagerFactory emf) {
            this.emf = emf;
        }

        public PlatformTransactionManager getPlatformTransactionManager() {
            return this.tm;
        }

        public void setPlatformTransactionManager(PlatformTransactionManager tm) {
            this.tm = tm;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

