/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.util.List;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.ResourceType;
import org.drools.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.container.spring.namespace.XsdParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ResourceDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String WORKSHEET_NAME_ATTRIBUTE = "worksheet-name";
    private static final String INPUT_TYPE_ATTRIBUTE = "input-type";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String SOURCE_ATTRIBUTE = "source";
    private static final String BASIC_AUTHENTICATION_ATTRIBUTE = "basic-authentication";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final String REF = "ref";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        List childElements;
        String name;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(DroolsResourceAdapter.class);
        if (StringUtils.hasText((String)element.getAttribute(REF))) {
            String ref = element.getAttribute(REF);
            this.emptyAttributeCheck(element.getLocalName(), REF, ref);
            return (AbstractBeanDefinition)parserContext.getRegistry().getBeanDefinition(ref);
        }
        String source = element.getAttribute(SOURCE_ATTRIBUTE);
        this.emptyAttributeCheck(element.getLocalName(), SOURCE_ATTRIBUTE, source);
        factory.addPropertyValue("resource", (Object)source);
        String type = element.getAttribute(TYPE_ATTRIBUTE);
        String resourceType = type == null || type.length() == 0 ? ResourceType.DRL.getName() : type;
        factory.addPropertyValue("resourceType", (Object)resourceType);
        boolean basicAuthenticationEnabled = element.getAttribute(BASIC_AUTHENTICATION_ATTRIBUTE) != null && element.getAttribute(BASIC_AUTHENTICATION_ATTRIBUTE).equalsIgnoreCase("enabled");
        factory.addPropertyValue("basicAuthenticationEnabled", (Object)basicAuthenticationEnabled);
        if (basicAuthenticationEnabled) {
            String username = element.getAttribute(USERNAME_ATTRIBUTE);
            factory.addPropertyValue("basicAuthenticationUsername", (Object)username);
            String password = element.getAttribute(PASSWORD_ATTRIBUTE);
            factory.addPropertyValue("basicAuthenticationPassword", (Object)password);
        }
        factory.addPropertyValue(NAME, (Object)((name = element.getAttribute(NAME)).length() == 0 ? null : name));
        String description = element.getAttribute(DESCRIPTION);
        factory.addPropertyValue(DESCRIPTION, (Object)(description.length() == 0 ? null : description));
        if ("xsd".equals(resourceType.toLowerCase())) {
            XsdParser.parse(element, parserContext, factory);
        } else if ("dtable".equals(resourceType.toLowerCase()) && !(childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"decisiontable-conf")).isEmpty()) {
            Element conf = (Element)childElements.get(0);
            DecisionTableConfigurationImpl dtableConf = new DecisionTableConfigurationImpl();
            String inputType = conf.getAttribute(INPUT_TYPE_ATTRIBUTE);
            this.emptyAttributeCheck(conf.getLocalName(), INPUT_TYPE_ATTRIBUTE, inputType);
            dtableConf.setInputType(DecisionTableInputType.valueOf((String)inputType));
            String worksheetName = conf.getAttribute(WORKSHEET_NAME_ATTRIBUTE);
            this.emptyAttributeCheck(conf.getLocalName(), WORKSHEET_NAME_ATTRIBUTE, worksheetName);
            dtableConf.setWorksheetName(worksheetName);
            factory.addPropertyValue("resourceConfiguration", (Object)dtableConf);
        }
        return factory.getBeanDefinition();
    }

    public void emptyAttributeCheck(String element, String attributeName, String attribute) {
        if (attribute == null || attribute.trim().equals("")) {
            throw new IllegalArgumentException("<" + element + "> requires a '" + attributeName + "' attribute");
        }
    }
}

