/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.UrlResource;
import org.drools.io.internal.InternalResource;
import org.springframework.beans.factory.InitializingBean;

public class DroolsResourceAdapter
implements InitializingBean {
    private Resource resource;
    private ResourceType resourceType;
    private ResourceConfiguration resourceConfiguration;

    public DroolsResourceAdapter() {
    }

    public DroolsResourceAdapter(String resource, ResourceType resourceType, ResourceConfiguration resourceConfiguration) {
        this.setResource(resource);
        this.resourceType = resourceType;
        this.resourceConfiguration = resourceConfiguration;
    }

    public void setResource(String resource) {
        this.resource = resource.trim().startsWith("classpath:") ? new ClassPathResource(resource.substring(resource.indexOf(58) + 1), ClassPathResource.class.getClassLoader()) : new UrlResource(resource);
    }

    public void setBasicAuthenticationEnabled(Boolean enabled) {
        if (enabled.booleanValue() && !(this.resource instanceof UrlResource)) {
            throw new IllegalArgumentException("Authentication Attributes are only valid for URL Resources");
        }
        if (this.resource instanceof UrlResource) {
            ((UrlResource)this.resource).setBasicAuthentication(enabled != false ? "enabled" : "disabled");
        }
    }

    public void setBasicAuthenticationUsername(String username) {
        if (!(this.resource instanceof UrlResource)) {
            throw new IllegalArgumentException("Authentication Attributes are only valid for URL Resources");
        }
        ((UrlResource)this.resource).setUsername(username);
    }

    public void setBasicAuthenticationPassword(String password) {
        if (!(this.resource instanceof UrlResource)) {
            throw new IllegalArgumentException("Authentication Attributes are only valid for URL Resources");
        }
        ((UrlResource)this.resource).setPassword(password);
    }

    public void setName(String name) {
        if (!(this.resource instanceof InternalResource)) {
            throw new IllegalArgumentException("'name' attribute is only valid for InternalResource subclasses");
        }
        ((InternalResource)this.resource).setName(name);
    }

    public void setDescription(String description) {
        if (!(this.resource instanceof InternalResource)) {
            throw new IllegalArgumentException("'description' attribute is only valid for InternalResource subclasses");
        }
        ((InternalResource)this.resource).setDescription(description);
    }

    public DroolsResourceAdapter(String resource, ResourceType resourceType) {
        this(resource, resourceType, null);
    }

    public DroolsResourceAdapter(String resource) {
        this(resource, ResourceType.DRL, null);
    }

    public DroolsResourceAdapter(String resource, String resourceType, ResourceConfiguration resourceConfiguration) {
        this(resource, ResourceType.getResourceType((String)resourceType), resourceConfiguration);
    }

    public DroolsResourceAdapter(String resource, String resourceType) {
        this(resource, resourceType, null);
    }

    public Resource getDroolsResource() {
        return this.resource;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public void setResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        this.resourceConfiguration = resourceConfiguration;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resource == null) {
            throw new IllegalArgumentException("resource property is mandatory");
        }
        if (this.resourceType == null) {
            throw new IllegalArgumentException("resourceType property is mandatory");
        }
        if (this.resourceConfiguration != null && !ResourceType.DTABLE.equals((Object)this.resourceType) && !ResourceType.XSD.equals((Object)this.resourceType)) {
            throw new IllegalArgumentException("Only Decision Tables or XSD resources can have configuration");
        }
    }
}

