/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import org.drools.container.spring.beans.KnowledgeLoggerBeanFactory;
import org.drools.container.spring.namespace.DefinitionParserHelper;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class KnowledgeLoggerFileParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(KnowledgeLoggerBeanFactory.class);
        String localName = element.getLocalName();
        String id = element.getAttribute("id");
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), "id", id);
        factory.addPropertyValue("name", (Object)id);
        String ksession = element.getAttribute("ksession");
        DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), "ksession", ksession);
        if (StringUtils.hasText((String)ksession)) {
            factory.addPropertyReference("ksession", ksession);
        }
        if ("fileKnowledgeLogger".equalsIgnoreCase(localName) || "threadedFileKnowledgeLogger".equalsIgnoreCase(localName)) {
            String file = element.getAttribute("file");
            DefinitionParserHelper.emptyAttributeCheck(element.getLocalName(), "file", file);
            if (StringUtils.hasText((String)file)) {
                factory.addPropertyValue("file", (Object)file);
            }
        }
        if ("fileKnowledgeLogger".equalsIgnoreCase(localName)) {
            factory.addPropertyValue("loggerType", (Object)KnowledgeLoggerBeanFactory.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_FILE);
        } else if ("threadedFileKnowledgeLogger".equalsIgnoreCase(localName)) {
            factory.addPropertyValue("loggerType", (Object)KnowledgeLoggerBeanFactory.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPE_THREADED_FILE);
        } else if ("consoleKnowledgeLogger".equalsIgnoreCase(localName)) {
            factory.addPropertyValue("loggerType", (Object)KnowledgeLoggerBeanFactory.KNOWLEDGE_LOGGER_TYPE.LOGGER_TYPES_CONSOLE);
        }
        return factory.getBeanDefinition();
    }
}

