/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.impl.GridNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridImpl
implements Grid {
    private Map<String, Object> services;
    private Map<String, GridNode> localNodes = new HashMap<String, GridNode>();
    private String id;

    public GridImpl() {
        this(null);
    }

    public GridImpl(Map<String, Object> services) {
        this.services = services == null ? new ConcurrentHashMap<String, Object>() : services;
        this.id = UUID.randomUUID().toString();
        this.init();
    }

    private void init() {
    }

    public Object get(String str) {
        return this.services.get(str);
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        throw new UnsupportedOperationException();
    }

    public void addService(Class cls, Object service) {
        this.addService(cls.getName(), service);
    }

    public void addService(String id, Object service) {
        this.services.put(id, service);
    }

    @Override
    public GridNode createGridNode(String id) {
        GridNodeImpl node = new GridNodeImpl(id);
        this.localNodes.put(id, node);
        return node;
    }

    @Override
    public void removeGridNode(String id) {
        this.localNodes.remove(id);
    }

    @Override
    public GridNode getGridNode(String id) {
        return this.localNodes.get(id);
    }
}

