/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.grid.GridNode;
import org.drools.grid.impl.GridNodeImpl;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.KieBaseConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactoryService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class KnowledgeBaseBeanFactory
implements FactoryBean,
InitializingBean {
    private KieBaseConfiguration conf;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private Map<String, EvaluatorDefinition> evaluators;
    private KnowledgeBase kbase;
    private GridNode node;
    private List<DroolsResourceAdapter> resources = Collections.emptyList();

    public Object getObject() throws Exception {
        return this.kbase;
    }

    public Class<? extends KnowledgeBase> getObjectType() {
        return KnowledgeBase.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.node == null) {
            this.node = new GridNodeImpl();
        }
        PackageBuilderConfiguration kconf = (PackageBuilderConfiguration)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        if (this.accumulateFunctions != null && !this.accumulateFunctions.isEmpty()) {
            for (Map.Entry<String, AccumulateFunction> entry : this.accumulateFunctions.entrySet()) {
                kconf.setOption((KnowledgeBuilderOption)AccumulateFunctionOption.get((String)entry.getKey(), (AccumulateFunction)entry.getValue()));
            }
        }
        if (this.evaluators != null && !this.evaluators.isEmpty()) {
            for (Map.Entry<String, AccumulateFunction> entry : this.evaluators.entrySet()) {
                kconf.setOption((KnowledgeBuilderOption)EvaluatorOption.get((String)entry.getKey(), (org.kie.api.runtime.rule.EvaluatorDefinition)((org.kie.api.runtime.rule.EvaluatorDefinition)entry.getValue())));
            }
        }
        KnowledgeBuilder kbuilder = this.node.get(KnowledgeBuilderFactoryService.class).newKnowledgeBuilder((KnowledgeBuilderConfiguration)kconf);
        this.kbase = this.conf != null ? this.node.get(KnowledgeBaseFactoryService.class).newKnowledgeBase(this.conf) : this.node.get(KnowledgeBaseFactoryService.class).newKnowledgeBase();
        ArrayList<JaxbConfigurationImpl> arrayList = new ArrayList<JaxbConfigurationImpl>();
        for (DroolsResourceAdapter res : this.resources) {
            if (res.getResourceType().equals((Object)ResourceType.XSD)) {
                arrayList.add((JaxbConfigurationImpl)res.getResourceConfiguration());
            }
            if (res.getResourceConfiguration() == null) {
                kbuilder.add(res.getDroolsResource(), res.getResourceType());
                continue;
            }
            kbuilder.add(res.getDroolsResource(), res.getResourceType(), res.getResourceConfiguration());
        }
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors.toString());
        }
        this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeBaseImpl kbaseImpl = (KnowledgeBaseImpl)this.kbase;
        kbaseImpl.jaxbClasses = new ArrayList();
        for (JaxbConfigurationImpl conf : arrayList) {
            kbaseImpl.jaxbClasses.add(conf.getClasses());
        }
    }

    public Map<String, AccumulateFunction> getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    public void setAccumulateFunctions(Map<String, AccumulateFunction> accumulateFunctions) {
        this.accumulateFunctions = accumulateFunctions;
    }

    public Map<String, EvaluatorDefinition> getEvaluators() {
        return this.evaluators;
    }

    public void setEvaluators(Map<String, EvaluatorDefinition> evaluators) {
        this.evaluators = evaluators;
    }

    public KieBaseConfiguration getConf() {
        return this.conf;
    }

    public void setConf(KieBaseConfiguration conf) {
        this.conf = conf;
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public GridNode getNode() {
        return this.node;
    }

    public List<DroolsResourceAdapter> getResources() {
        return this.resources;
    }

    public void setResources(List<DroolsResourceAdapter> resources) {
        this.resources = resources;
    }

    public void setNode(GridNode gridNode) {
        this.node = gridNode;
    }
}

