/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.LinkedList;
import java.util.List;
import org.drools.template.model.AttributedDRLElement;
import org.drools.template.model.DRLJavaEmitter;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.DeclaredType;
import org.drools.template.model.Functions;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.model.Queries;
import org.drools.template.model.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
extends AttributedDRLElement
implements DRLJavaEmitter {
    private String _name;
    private List<Import> _imports;
    private List<Global> _variables;
    private List<Rule> _rules;
    private Functions _functions;
    private Queries _queries;
    private DeclaredType _declaredTypes;

    public Package(String name) {
        this._name = name;
        this._imports = new LinkedList<Import>();
        this._variables = new LinkedList<Global>();
        this._rules = new LinkedList<Rule>();
        this._functions = new Functions();
        this._queries = new Queries();
        this._declaredTypes = new DeclaredType();
    }

    public void addImport(Import imp) {
        this._imports.add(imp);
    }

    public void addVariable(Global varz) {
        this._variables.add(varz);
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
    }

    public void addFunctions(String listing) {
        this._functions.setFunctionsListing(listing);
    }

    public void addQueries(String listing) {
        this._queries.setQueriesListing(listing);
    }

    public void addDeclaredType(String declaration) {
        this._declaredTypes.setDeclaredTypeListing(declaration);
    }

    public String getName() {
        return this._name;
    }

    public List<Import> getImports() {
        return this._imports;
    }

    public List<Global> getVariables() {
        return this._variables;
    }

    public List<Rule> getRules() {
        return this._rules;
    }

    @Override
    public void renderDRL(DRLOutput out) {
        if (this._name != null) {
            out.writeLine("package " + this._name.replace(' ', '_') + ";");
        }
        out.writeLine("//generated from Decision Table");
        this.renderDRL(this._imports, out);
        this.renderDRL(this._variables, out);
        this._functions.renderDRL(out);
        this._queries.renderDRL(out);
        this._declaredTypes.renderDRL(out);
        super.renderDRL(out);
        this.renderDRL(this._rules, out);
    }

    private void renderDRL(List<? extends DRLJavaEmitter> list, DRLOutput out) {
        for (DRLJavaEmitter dRLJavaEmitter : list) {
            dRLJavaEmitter.renderDRL(out);
        }
    }
}

