/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.drools.template.parser.DefaultGenerator;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateColumn;
import org.drools.template.parser.TemplateContainer;
import org.drools.template.parser.TemplateRuleBase;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBaseFactory;

public class DefaultTemplateRuleBase
implements TemplateRuleBase {
    private InternalKnowledgeBase kBase;

    public DefaultTemplateRuleBase(TemplateContainer tc) {
        this.kBase = this.readKnowledgeBase(this.getDTRules(tc.getTemplates()));
    }

    @Override
    public KieSession newStatefulSession() {
        return this.kBase.newKieSession();
    }

    private String getDTRules(Map<String, RuleTemplate> templates) {
        Package p = new Package(DefaultTemplateRuleBase.class.getPackage().getName());
        this.addImports(p);
        this.addGlobals(p);
        int i = 1;
        for (RuleTemplate template : templates.values()) {
            this.createTemplateRule(p, i++, template);
        }
        DRLOutput out = new DRLOutput();
        p.renderDRL(out);
        return out.getDRL();
    }

    private void createTemplateRule(Package p, int index, RuleTemplate template) {
        Rule rule = new Rule(template.getName(), null, index);
        Condition condition = new Condition();
        condition.setSnippet("r : Row()");
        rule.addCondition(condition);
        this.createColumnConditions(template, rule);
        rule.addConsequence(this.createConsequence(template));
        p.addRule(rule);
    }

    private void createColumnConditions(RuleTemplate template, Rule rule) {
        for (TemplateColumn column : template.getColumns()) {
            column.addCondition(rule);
        }
    }

    private void addGlobals(Package p) {
        Global global = new Global();
        global.setClassName(DefaultGenerator.class.getName());
        global.setIdentifier("generator");
        p.addVariable(global);
    }

    private void addImports(Package p) {
        Import drlImport1 = new Import();
        drlImport1.setClassName(Map.class.getName());
        Import drlImport2 = new Import();
        drlImport2.setClassName(HashMap.class.getName());
        p.addImport(drlImport1);
        p.addImport(drlImport2);
    }

    private Consequence createConsequence(RuleTemplate template) {
        StringBuffer action = new StringBuffer();
        action.append("generator.generate( \"");
        action.append(template.getName()).append("\", r);");
        Consequence consequence = new Consequence();
        consequence.setSnippet(action.toString());
        return consequence;
    }

    private InternalKnowledgeBase readKnowledgeBase(String drl) {
        try {
            StringReader source = new StringReader(drl);
            KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
            builder.addPackageFromDrl((Reader)source);
            InternalKnowledgePackage pkg = builder.getPackage();
            InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
            kBase.addPackage(pkg);
            return kBase;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

