/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Map;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;
import org.drools.util.StringUtils;
import org.kie.api.runtime.KieSession;

public class ArrayCell
implements Cell {
    Row row;
    String value;
    ArrayColumn column;
    private String[] values;

    public ArrayCell(Row r, ArrayColumn c) {
        this.row = r;
        this.column = c;
    }

    @Override
    public void addValue(Map<String, Object> vars) {
        for (int i = 0; i < this.values.length; ++i) {
            vars.put(this.column.getName() + i, this.values[i]);
        }
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void insert(KieSession session) {
        session.insert((Object)this);
        for (int i = 0; i < this.values.length; ++i) {
            Cell cell = this.column.getType().createCell(this.row);
            cell.setValue(this.values[i]);
            cell.setIndex(i);
            cell.insert(session);
        }
    }

    @Override
    public void setIndex(int i) {
        throw new RuntimeException("You cannot call setQueueIndex on an ArrayCell");
    }

    @Override
    public int getIndex() {
        return -1;
    }

    @Override
    public void setValue(String v) {
        this.value = v;
        this.values = StringUtils.splitPreserveAllTokens((String)this.value, (String)",");
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.value);
    }
}

