/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.beliefsystem.simple;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;

public class SimpleBeliefSet
extends LinkedList<SimpleMode>
implements BeliefSet<SimpleMode> {
    protected BeliefSystem beliefSystem;
    protected InternalFactHandle fh;
    protected WorkingMemoryAction wmAction;

    public SimpleBeliefSet(BeliefSystem beliefSystem, InternalFactHandle fh) {
        this.beliefSystem = beliefSystem;
        this.fh = fh;
    }

    public SimpleBeliefSet() {
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.fh;
    }

    @Override
    public void cancel(PropagationContext context) {
        LogicalDependency node;
        SimpleMode entry = (SimpleMode)this.getFirst();
        while (entry != this.getLast()) {
            SimpleMode temp = (SimpleMode)entry.getNext();
            node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove((LinkedListNode)node);
            this.remove(entry);
            entry = temp;
        }
        LinkedListEntry last = (LinkedListEntry)this.getFirst();
        node = (LogicalDependency)last.getObject();
        node.getJustifier().getLogicalDependencies().remove((LinkedListNode)node);
        this.beliefSystem.delete(node, this, context);
    }

    @Override
    public void clear(PropagationContext context) {
        SimpleMode entry = (SimpleMode)this.getFirst();
        while (entry != null) {
            SimpleMode temp = (SimpleMode)entry.getNext();
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove((LinkedListNode)node);
            this.remove(entry);
            entry = temp;
        }
    }

    public WorkingMemoryAction getWorkingMemoryAction() {
        return this.wmAction;
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
        this.wmAction = wmAction;
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public boolean isDecided() {
        return true;
    }

    @Override
    public boolean isConflicting() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return !this.isEmpty();
    }
}

