/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.traits.core.metadata.Lit;
import org.drools.traits.core.metadata.ManyValuedMetaProperty;
import org.drools.traits.core.metadata.OneValuedMetaProperty;
import org.drools.traits.core.metadata.PropertyLiteral;

public abstract class ToManyPropertyLiteral<T, R>
extends PropertyLiteral<T, R, List<R>>
implements ManyValuedMetaProperty<T, R, List<R>> {
    public ToManyPropertyLiteral(int index, Class<T> klass, String name) {
        super(index, klass, name);
    }

    public ToManyPropertyLiteral(int index, String name, URI key) {
        super(index, name, key);
    }

    public abstract void set(T var1, List<R> var2);

    @Override
    public void set(T o, List<R> values, Lit mode) {
        switch (mode) {
            case SET: {
                this.set(o, new ArrayList<R>(values));
                break;
            }
            case ADD: {
                ArrayList<R> list = (ArrayList<R>)this.get(o);
                if (list == null) {
                    list = new ArrayList<R>();
                    this.set(o, list);
                }
                list.addAll(values);
                break;
            }
            case REMOVE: {
                List curr = (List)this.get(o);
                if (curr == null) break;
                curr.removeAll(values);
            }
        }
    }

    @Override
    public void set(T o, R value, Lit mode) {
        switch (mode) {
            case SET: {
                this.set(o, Collections.singletonList(value));
                break;
            }
            case ADD: {
                ArrayList<R> list = (ArrayList<R>)this.get(o);
                if (list == null) {
                    list = new ArrayList<R>();
                }
                list.add(value);
                this.set(o, list);
                break;
            }
            case REMOVE: {
                List curr = (List)this.get(o);
                if (curr != null) {
                    curr.remove(value);
                }
                this.set(o, curr);
            }
        }
    }

    @Override
    public boolean isManyValued() {
        return true;
    }

    @Override
    public OneValuedMetaProperty<T, List<R>> asFunctionalProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManyValuedMetaProperty<T, R, List<R>> asManyValuedProperty() {
        return this;
    }
}

