/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.asm.ClassFieldInspectorImpl;
import org.drools.traits.core.factmodel.TraitFactoryImpl;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitBuilderUtil {
    static MixinInfo findMixinInfo(Class<?> traitClass) {
        if (traitClass == null) {
            return null;
        }
        Map<Class<?>, List<Method>> mixinMethodMap = TraitBuilderUtil.findMixinMethodImpls(traitClass);
        if (mixinMethodMap.isEmpty()) {
            return null;
        }
        MixinInfo mixinInfo = new MixinInfo(traitClass);
        try {
            mixinInfo.mixinClasses = new ArrayList();
            mixinInfo.mixinClasses.addAll(mixinMethodMap.keySet());
            mixinInfo.mixinMethods = new HashMap();
            mixinInfo.mixinGetSet = new HashMap();
            for (Map.Entry<Class<?>, List<Method>> entry : mixinMethodMap.entrySet()) {
                Class<?> mixinClass = entry.getKey();
                ClassFieldInspectorImpl cfi = new ClassFieldInspectorImpl(mixinClass);
                for (Method m : entry.getValue()) {
                    try {
                        traitClass.getMethod(m.getName(), m.getParameterTypes());
                        if (cfi.getGetterMethods().containsValue(m) || cfi.getSetterMethods().containsValue(m)) {
                            Map map = mixinInfo.mixinGetSet.computeIfAbsent(mixinClass, k -> new HashMap());
                            map.put(m.getName(), m);
                            continue;
                        }
                        Set set = mixinInfo.mixinMethods.computeIfAbsent(mixinClass, k -> new HashSet());
                        set.add(m);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mixinInfo;
    }

    private static Map<Class<?>, List<Method>> findMixinMethodImpls(Class<?> traitClass) {
        LinkedHashMap map = new LinkedHashMap();
        TraitBuilderUtil.findMixinMethodImpls(traitClass, map);
        return map;
    }

    private static void findMixinMethodImpls(Class<?> traitClass, Map<Class<?>, List<Method>> map) {
        Trait annTrait = TraitBuilderUtil.getAnnotation(traitClass, Trait.class);
        if (TraitBuilderUtil.hasImpl(annTrait)) {
            Class mixinClass = annTrait.impl();
            map.put(mixinClass, Arrays.asList(mixinClass.getMethods()));
        }
        if (traitClass.getSuperclass() != null) {
            TraitBuilderUtil.findMixinMethodImpls(traitClass.getSuperclass(), map);
        }
        for (Class<?> intf : traitClass.getInterfaces()) {
            TraitBuilderUtil.findMixinMethodImpls(intf, map);
        }
    }

    static String getMixinName(Class<?> mixinClass) {
        return mixinClass.getSimpleName().substring(0, 1).toLowerCase() + mixinClass.getSimpleName().substring(1);
    }

    private static boolean hasImpl(Trait annTrait) {
        return annTrait != null && !annTrait.impl().equals(Trait.NullMixin.class);
    }

    private static <K extends Annotation> K getAnnotation(Class<?> klass, Class<K> annotationClass) {
        if (klass.equals(Thing.class)) {
            return null;
        }
        K ann = klass.getAnnotation(annotationClass);
        if (ann == null) {
            for (Class<?> sup : klass.getInterfaces()) {
                ann = TraitBuilderUtil.getAnnotation(sup, annotationClass);
                if (ann == null) continue;
                return ann;
            }
            return null;
        }
        return ann;
    }

    static void buildMixinMethods(String proxyName, MixinInfo mixinInfo, ClassWriter cw) {
        if (mixinInfo == null) {
            return;
        }
        HashSet<String> createdSignatures = new HashSet<String>();
        for (Class<?> mixinClass : mixinInfo.mixinClasses) {
            Map<String, Method> map;
            String mixin = TraitBuilderUtil.getMixinName(mixinClass);
            Set<Method> methods = mixinInfo.mixinMethods.get(mixinClass);
            if (methods != null) {
                TraitBuilderUtil.buildMixinMethods(cw, proxyName, mixin, mixinClass, mixinInfo, methods, createdSignatures);
            }
            if ((map = mixinInfo.mixinGetSet.get(mixinClass)) == null) continue;
            TraitBuilderUtil.buildMixinMethods(cw, proxyName, mixin, mixinClass, mixinInfo, map.values(), createdSignatures);
        }
    }

    private static void buildMixinMethods(ClassWriter cw, String wrapperName, String mixin, Class mixinClass, MixinInfo mixinInfo, Collection<Method> mixinMethods, Set<String> createdSignatures) {
        for (Method method : mixinMethods) {
            String signature = TraitFactoryImpl.buildSignature(method);
            String methodSignature = method.getName() + signature;
            if (createdSignatures.contains(methodSignature)) {
                if (!mixinInfo.throwsErrorOnConflict()) continue;
                throw new RuntimeException("Conflict on method: " + method.getName());
            }
            createdSignatures.add(methodSignature);
            MethodVisitor mv = cw.visitMethod(1, method.getName(), signature, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)wrapperName), mixin, Type.getDescriptor((Class)mixinClass));
            int j = 1;
            for (Class<?> arg : method.getParameterTypes()) {
                mv.visitVarInsn(AsmUtil.varType((String)arg.getName()), j++);
            }
            mv.visitMethodInsn(182, Type.getInternalName((Class)mixinClass), method.getName(), signature, false);
            mv.visitInsn(AsmUtil.returnType((String)method.getReturnType().getName()));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    static class MixinInfo {
        final Class<?> traitClass;
        List<Class<?>> mixinClasses = null;
        Map<Class<?>, Set<Method>> mixinMethods = null;
        Map<Class<?>, Map<String, Method>> mixinGetSet = null;

        MixinInfo(Class<?> traitClass) {
            this.traitClass = traitClass;
        }

        boolean isMixinGetter(FieldDefinition field) {
            String getter = BuildUtils.getterName((String)field.getName(), (String)field.getTypeName());
            for (Map<String, Method> map : this.mixinGetSet.values()) {
                if (!map.containsKey(getter)) continue;
                return true;
            }
            return false;
        }

        public boolean throwsErrorOnConflict() {
            return this.traitClass.getAnnotation(Trait.class).mixinSolveConflicts() == Trait.MixinConflictResolutionStrategy.ERROR_ON_CONFLICT;
        }
    }
}

