/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitUtils;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.CodedHierarchy;
import org.drools.core.util.HierarchyEncoder;
import org.kie.api.runtime.ObjectFilter;

public class IsAEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String isAOp = "isA";
    public static Operator ISA;
    public static Operator NOT_ISA;
    private static String[] SUPPORTED_IDS;
    private Evaluator[] evaluator;

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        IsAEvaluator evaluator = new IsAEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return type.equals((Object)ValueType.TRAIT_TYPE);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    static {
        if (Operator.determineOperator((String)isAOp, (boolean)false) == null) {
            ISA = Operator.addOperatorToRegistry((String)isAOp, (boolean)false);
            NOT_ISA = Operator.addOperatorToRegistry((String)isAOp, (boolean)true);
            SUPPORTED_IDS = new String[]{isAOp};
        }
    }

    public static class IsAEvaluator
    extends BaseEvaluator {
        private BitSet cachedLiteral;
        private Object cachedValue;

        public IsAEvaluator() {
        }

        public void setParameterText(String parameterText) {
        }

        public IsAEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_ISA : ISA);
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle handle, FieldValue value) {
            Object objectValue = extractor.getValue(reteEvaluator, handle.getObject());
            Object literal = value.getValue();
            if (this.cachedValue != literal) {
                this.cachedValue = literal;
                this.cacheLiteral(literal, reteEvaluator);
            }
            if (objectValue == null) {
                return this.getOperator().isNegated();
            }
            if (objectValue instanceof Thing) {
                Thing thing = (Thing)objectValue;
                TraitableBean core = (TraitableBean)thing.getCore();
                BitSet code = core.getCurrentTypeCode();
                if (code != null) {
                    return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
                }
                boolean hasTrait = this.getOperator().isNegated() ^ this.hasTrait(core, literal);
                return hasTrait || literal instanceof Class && this.getOperator().isNegated() ^ ((Class)literal).isInstance(objectValue);
            }
            if (objectValue instanceof TraitableBean) {
                TraitableBean core = (TraitableBean)objectValue;
                BitSet code = core.getCurrentTypeCode();
                if (code != null) {
                    return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
                }
                return this.getOperator().isNegated() ^ this.hasTrait(core, literal);
            }
            TraitableBean core = this.lookForWrapper(objectValue, reteEvaluator);
            if (core == null) {
                if (literal instanceof Class) {
                    return this.getOperator().isNegated() ^ ((Class)literal).isInstance(objectValue);
                }
                return this.getOperator().isNegated();
            }
            BitSet code = core.getCurrentTypeCode();
            if (code != null) {
                return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
            }
            return this.getOperator().isNegated() ^ this.hasTrait(core, literal);
        }

        private boolean hasTrait(TraitableBean core, Object value) {
            if (value instanceof Class) {
                return core.hasTrait(((Class)value).getName());
            }
            if (value instanceof String) {
                return core.hasTrait((String)value);
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (this.hasTrait(core, o)) continue;
                    return false;
                }
                return true;
            }
            throw new UnsupportedOperationException(" IsA Operator : Unsupported literal " + value);
        }

        private void cacheLiteral(Object value, ReteEvaluator reteEvaluator) {
            HierarchyEncoder x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            this.cachedLiteral = this.getCode(value, (CodedHierarchy)x);
        }

        private BitSet getCode(Object value, CodedHierarchy x) {
            if (value instanceof Class) {
                String typeName = ((Class)value).getName();
                return x.getCode((Object)typeName);
            }
            if (value instanceof String) {
                return x.getCode(value);
            }
            if (value instanceof Collection) {
                BitSet code = null;
                for (Object o : (Collection)value) {
                    if (code == null) {
                        code = (BitSet)this.getCode(o, x).clone();
                        continue;
                    }
                    code.and(this.getCode(o, x));
                }
                return code;
            }
            throw new UnsupportedOperationException(" IsA Operator : Unsupported literal " + value);
        }

        protected TraitableBean lookForWrapper(final Object objectValue, ReteEvaluator reteEvaluator) {
            Iterator iter = reteEvaluator.getDefaultEntryPoint().getObjectStore().iterateObjects(new ObjectFilter(){

                public boolean accept(Object object) {
                    if (object instanceof TraitProxy) {
                        Object core = ((TraitProxy)object).getObject();
                        if (core instanceof CoreWrapper) {
                            core = ((CoreWrapper)core).getCore();
                        }
                        return core == objectValue;
                    }
                    return false;
                }
            });
            if (iter.hasNext()) {
                return ((TraitProxy)iter.next()).getObject();
            }
            return null;
        }

        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
            Object source = leftExtractor.getValue(reteEvaluator, left != null ? left.getObject() : null);
            Object target = rightExtractor.getValue(reteEvaluator, right != null ? right.getObject() : null);
            return this.compare(source, target, reteEvaluator);
        }

        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object target = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object source = context.getFieldExtractor().getValue(reteEvaluator, right.getObject());
            return this.compare(source, target, reteEvaluator);
        }

        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object target = context.getFieldExtractor().getValue(reteEvaluator, left.getObject());
            Object source = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return this.compare(source, target, reteEvaluator);
        }

        private boolean compare(Object source, Object target, ReteEvaluator reteEvaluator) {
            TraitableBean tbean;
            HierarchyEncoder x;
            BitSet sourceTraits = null;
            BitSet targetTraits = null;
            if (source instanceof Class) {
                x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                sourceTraits = x.getCode((Object)((Class)source).getName());
            } else if (source instanceof Thing) {
                sourceTraits = ((TraitableBean)((Thing)source).getCore()).getCurrentTypeCode();
                if (sourceTraits == null && source instanceof TraitType) {
                    x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                    sourceTraits = x.getCode((Object)((TraitType)source)._getTraitName());
                }
            } else if (source instanceof TraitableBean) {
                sourceTraits = ((TraitableBean)source).getCurrentTypeCode();
            } else if (source instanceof String) {
                x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                sourceTraits = x.getCode(source);
            } else {
                tbean = this.lookForWrapper(source, reteEvaluator);
                if (tbean != null) {
                    sourceTraits = tbean.getCurrentTypeCode();
                }
            }
            if (target instanceof Class) {
                x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode((Object)((Class)target).getName());
            } else if (target instanceof String) {
                x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode(target);
            } else if (target instanceof Thing) {
                targetTraits = ((TraitableBean)((Thing)target).getCore()).getCurrentTypeCode();
                if (targetTraits == null && target instanceof TraitType) {
                    x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                    targetTraits = x.getCode((Object)((TraitType)target)._getTraitName());
                }
            } else if (target instanceof TraitableBean) {
                targetTraits = ((TraitableBean)target).getCurrentTypeCode();
            } else if (target instanceof Collection) {
                x = reteEvaluator.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = this.getCode(target, (CodedHierarchy)x);
            } else {
                tbean = this.lookForWrapper(target, reteEvaluator);
                if (tbean != null) {
                    targetTraits = tbean.getCurrentTypeCode();
                }
            }
            if (sourceTraits == null || targetTraits == null) {
                return this.getOperator().isNegated();
            }
            return this.isA(sourceTraits, targetTraits) ^ this.getOperator().isNegated();
        }

        private boolean isA(BitSet sourceTraits, BitSet targetTraits) {
            if (sourceTraits == null) {
                return false;
            }
            return targetTraits == null || TraitUtils.supersetOrEqualset((BitSet)sourceTraits, (BitSet)targetTraits);
        }

        public String toString() {
            return "IsAEvaluatorDefinition isA";
        }
    }
}

