/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.metadata;

import java.io.Serializable;
import java.net.URI;
import org.drools.traits.core.metadata.MetaProperty;

public abstract class PropertyLiteral<T, R, C>
implements MetaProperty<T, R, C>,
Serializable {
    private final int index;
    private final String name;
    private final URI key;

    public PropertyLiteral(int index, Class<T> klass, String name) {
        this(index, name, PropertyLiteral.asURI(name, klass));
    }

    @Override
    public abstract boolean isDatatype();

    private static <T> URI asURI(String name, Class klass) {
        if (klass == null) {
            klass = PropertyLiteral.class;
        }
        return URI.create("http://" + klass.getPackage().getName() + "/" + name);
    }

    public PropertyLiteral(int index, String name, URI key) {
        this.index = index;
        this.name = name;
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyLiteral that = (PropertyLiteral)o;
        return this.key.equals(that.key);
    }

    @Override
    public int compareTo(MetaProperty<T, R, C> o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getKey() {
        return this.key;
    }

    @Override
    public URI getUri() {
        return this.key;
    }

    @Override
    public Object getId() {
        return this.key;
    }
}

