/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class VerifierKnowledgeBaseBuilder {
    private List<VerifierError> errors = new ArrayList<VerifierError>();

    public KieBase newVerifierKnowledgeBase(VerifierConfiguration configuration) {
        InternalKnowledgeBase verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        LanguageLevelOption option = (LanguageLevelOption)((KnowledgeBuilderImpl)kbuilder).getBuilderConfiguration().getOption(LanguageLevelOption.KEY);
        if (option == LanguageLevelOption.DRL10) {
            throw new UnsupportedOperationException("Verifier does not support DRL10");
        }
        if (configuration.getVerifyingResources() != null) {
            for (Resource resource : configuration.getVerifyingResources().keySet()) {
                kbuilder.add(resource, configuration.getVerifyingResources().get(resource));
            }
        }
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                this.errors.add(new VerifierError("Error compiling verifier rules: " + ((KnowledgeBuilderError)errors.next()).getMessage()));
            }
        }
        verifierKnowledgeBase.addPackages(kbuilder.getKnowledgePackages());
        return verifierKnowledgeBase;
    }

    public List<VerifierError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

