/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import java.util.HashSet;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Gap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class RangeCheckDoublesTest
extends TestBaseOld {
    @Test
    public void testSmallerOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if smaller than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4a"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testGreaterOrEqual() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, if greater than or equal is missing"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 4b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 5b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndGreaterThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and greater than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 7b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 3"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9b"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }

    @Test
    public void testEqualAndSmallerThan() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("rangeChecks/Doubles.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("MissingRangesForDoubles.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Range check for doubles, equal and smaller than"));
        HashSet<String> rulesThatHadErrors = new HashSet<String>();
        for (Object o : session.getObjects()) {
            if (!(o instanceof Gap)) continue;
            rulesThatHadErrors.add(((Gap)o).getRuleName());
        }
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 1"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 6b"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 2"));
        Assert.assertTrue((boolean)rulesThatHadErrors.remove("Double gap rule 9a"));
        if (!rulesThatHadErrors.isEmpty()) {
            for (String string : rulesThatHadErrors) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

