/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.optimisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.verifier.TestBaseOld;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessage;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;

public class PatternOrderTest
extends TestBaseOld {
    @Test
    public void testEvalOrderInsideOperator() throws Exception {
        KieSession session = this.getStatelessKieSession(this.getClass().getResourceAsStream("PatternOrder.drl"));
        VerifierReport result = VerifierReportFactory.newVerifierReport();
        Collection<? extends Object> testData = this.getTestData(this.getClass().getResourceAsStream("OptimisationPatternOrderTest.drl"), result.getVerifierData());
        session.setGlobal("result", (Object)result);
        for (Object object : testData) {
            session.insert(object);
        }
        session.fireAllRules((AgendaFilter)new RuleNameMatchesAgendaFilter("Optimise evals inside pattern"));
        Iterator iter = result.getBySeverity(Severity.NOTE).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof VerifierMessage)) continue;
            String name = ((VerifierMessage)o).getCauses().toArray(new RuleComponent[2])[0].getRuleName();
            arrayList.add(name);
        }
        Assert.assertTrue((boolean)arrayList.remove("Wrong eval order 1"));
        if (!arrayList.isEmpty()) {
            for (String string : arrayList) {
                Assert.fail((String)("Rule " + string + " caused an error."));
            }
        }
    }
}

