/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.data;

import java.util.Collection;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.verifier.VerifierComponentMockFactory;
import org.drools.verifier.components.EnumField;
import org.drools.verifier.components.EnumRestriction;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.InlineEvalDescr;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternEval;
import org.drools.verifier.components.PatternOperatorDescr;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.QualifiedIdentifierRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.ReturnValueFieldDescr;
import org.drools.verifier.components.ReturnValueRestriction;
import org.drools.verifier.components.RuleEval;
import org.drools.verifier.components.RuleOperatorDescr;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.TextConsequence;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierAccessorDescr;
import org.drools.verifier.components.VerifierAccumulateDescr;
import org.drools.verifier.components.VerifierCollectDescr;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierFieldAccessDescr;
import org.drools.verifier.components.VerifierFromDescr;
import org.drools.verifier.components.VerifierMethodAccessDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.data.VerifierReportFactory;
import org.junit.Assert;
import org.junit.Test;

public class VerifierDataMapsTest {
    @Test
    public void testSaveVerifierComponentAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        rule.setName("0");
        String rulePath = rule.getPath();
        data.add((VerifierComponent)rule);
        Collection all = data.getAll();
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)rule, (Object)all.toArray()[0]);
        Collection rules = data.getAll(VerifierComponentType.RULE);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)rule, (Object)rules.toArray()[0]);
        VerifierRule rule2 = (VerifierRule)data.getVerifierObject(VerifierComponentType.RULE, rulePath);
        Assert.assertNotNull((Object)rule2);
        Assert.assertEquals((Object)rule, (Object)rule2);
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllComponentTypes() {
        RulePackage rulePackage = VerifierComponentMockFactory.createPackage1();
        this.saveVerifierComponentAndGet((VerifierComponent)rulePackage);
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        this.saveVerifierComponentAndGet((VerifierComponent)rule);
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((VerifierComponent)pattern);
        this.saveVerifierComponentAndGet((VerifierComponent)new InlineEvalDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new ObjectType((BaseDescr)new PackageDescr("testPackage1")));
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleOperatorDescr((BaseDescr)new AndDescr(), rule, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternOperatorDescr(pattern, OperatorDescrType.AND));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubPattern(pattern, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new ReturnValueFieldDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new SubRule(rule, 0));
        this.saveVerifierComponentAndGet((VerifierComponent)new TextConsequence(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternVariable(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccessorDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierAccumulateDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierCollectDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new RuleEval(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFieldAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierFromDescr(pattern));
        this.saveVerifierComponentAndGet((VerifierComponent)new VerifierMethodAccessDescr(rule));
        this.saveVerifierComponentAndGet((VerifierComponent)new PatternEval(pattern));
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllFields() {
        this.saveVerifierComponentAndGet((Field)new EnumField((BaseDescr)new PackageDescr("testPackage1")));
        this.saveVerifierComponentAndGet(new Field((BaseDescr)new PackageDescr("testPackage1")));
    }

    @Test
    public void testSaveVerifierComponentAndGetForAllRestrictions() {
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        this.saveVerifierComponentAndGet((Restriction)LiteralRestriction.createRestriction((Pattern)pattern, (String)""));
        this.saveVerifierComponentAndGet((Restriction)new EnumRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new QualifiedIdentifierRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new ReturnValueRestriction(pattern));
        this.saveVerifierComponentAndGet((Restriction)new VariableRestriction(pattern));
    }

    @Test
    public void testSavePatternAndGet() {
        VerifierData data = VerifierReportFactory.newVerifierData();
        VerifierRule rule = VerifierComponentMockFactory.createRule1();
        Assert.assertNotNull((Object)rule.getName());
        Assert.assertEquals((Object)"testRule1", (Object)rule.getName());
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        Pattern pattern = VerifierComponentMockFactory.createPattern1();
        Assert.assertNotNull((Object)pattern.getRulePath());
        Assert.assertEquals((Object)rule.getPath(), (Object)pattern.getRulePath());
        Assert.assertNotNull((Object)pattern.getName());
        Assert.assertEquals((Object)rule.getName(), (Object)pattern.getRuleName());
        pattern.setObjectTypePath(objectType.getPath());
        Assert.assertNotNull((Object)pattern.getObjectTypePath());
        Assert.assertEquals((Object)objectType.getPath(), (Object)pattern.getObjectTypePath());
        data.add((VerifierComponent)rule);
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)pattern);
        Collection all = data.getAll();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(pattern));
        Assert.assertTrue((boolean)all.contains(objectType));
        Assert.assertTrue((boolean)all.contains(rule));
        Collection components = data.getAll(pattern.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)pattern, (Object)components.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assert.assertNotNull((Object)objectType2);
        Assert.assertEquals((Object)objectType, (Object)objectType2);
        VerifierComponent rule2 = data.getVerifierObject(rule.getVerifierComponentType(), rule.getPath());
        Assert.assertNotNull((Object)rule2);
        Assert.assertEquals((Object)rule, (Object)rule2);
    }

    private void saveVerifierComponentAndGet(Field field) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        field.setObjectTypePath(objectType.getPath());
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        Collection all = data.getAll();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(objectType));
        Assert.assertTrue((boolean)all.contains(field));
        Collection fields = data.getAll(field.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)fields.size());
        Assert.assertEquals((Object)field, (Object)fields.toArray()[0]);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        Assert.assertNotNull((Object)field2);
        Assert.assertEquals((Object)field, (Object)field2);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)objectTypes.size());
        Assert.assertEquals((Object)objectType, (Object)objectTypes.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assert.assertNotNull((Object)objectType2);
        Assert.assertEquals((Object)objectType, (Object)objectType2);
    }

    private void saveVerifierComponentAndGet(Restriction component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        ObjectType objectType = new ObjectType((BaseDescr)new PackageDescr("testPackage1"));
        Field field = new Field((BaseDescr)new PackageDescr("testPackage1"));
        field.setObjectTypePath(objectType.getPath());
        component.setFieldPath(field.getPath());
        Assert.assertNotNull((Object)component.getFieldPath());
        data.add((VerifierComponent)objectType);
        data.add((VerifierComponent)field);
        data.add((VerifierComponent)component);
        Collection all = data.getAll();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertTrue((boolean)all.contains(objectType));
        Assert.assertTrue((boolean)all.contains(field));
        Assert.assertTrue((boolean)all.contains(component));
        Collection components = data.getAll(component.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)component, (Object)components.toArray()[0]);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        Assert.assertNotNull((Object)component2);
        Assert.assertEquals((Object)component, (Object)component2);
        Collection fields = data.getAll(field.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)fields.size());
        Assert.assertEquals((Object)field, (Object)fields.toArray()[0]);
        VerifierComponent field2 = data.getVerifierObject(field.getVerifierComponentType(), field.getPath());
        Assert.assertNotNull((Object)field2);
        Assert.assertEquals((Object)field, (Object)field2);
        Collection objectTypes = data.getAll(objectType.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)objectTypes.size());
        Assert.assertEquals((Object)objectType, (Object)objectTypes.toArray()[0]);
        VerifierComponent objectType2 = data.getVerifierObject(objectType.getVerifierComponentType(), objectType.getPath());
        Assert.assertNotNull((Object)objectType2);
        Assert.assertEquals((Object)objectType, (Object)objectType2);
    }

    private void saveVerifierComponentAndGet(VerifierComponent component) {
        VerifierData data = VerifierReportFactory.newVerifierData();
        data.add(component);
        Collection all = data.getAll();
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)component, (Object)all.toArray()[0]);
        Collection components = data.getAll(component.getVerifierComponentType());
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)component, (Object)components.toArray()[0]);
        VerifierComponent component2 = data.getVerifierObject(component.getVerifierComponentType(), component.getPath());
        Assert.assertNotNull((Object)component2);
        Assert.assertEquals((Object)component, (Object)component2);
    }
}

