/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import org.drools.drl.parser.impl.Operator;
import org.drools.verifier.components.Field;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.MissingRange;

public class MissingNumberPattern
extends MissingRange
implements Comparable<MissingRange> {
    private final String valueType;
    private final String value;

    @Override
    public int compareTo(MissingRange another) {
        return super.compareTo(another);
    }

    public MissingNumberPattern(Field field, Operator operator, String valueType, String value) {
        super(field, operator);
        this.valueType = valueType;
        this.value = value;
    }

    public String getRuleName() {
        return null;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    public Object getValueAsObject() {
        if (this.valueType.equals("java.lang.Boolean")) {
            return Boolean.valueOf(this.value);
        }
        if (this.valueType.equals("java.util.Date")) {
            try {
                String fmt = System.getProperty("drools.dateformat");
                if (fmt == null) {
                    fmt = "dd-MMM-yyyy";
                }
                return new SimpleDateFormat(fmt, Locale.ENGLISH).parse(this.value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            if (this.valueType.equals("java.lang.Double")) {
                return Double.valueOf(this.value);
            }
            if (this.valueType.equals("java.lang.Integer")) {
                return Integer.valueOf(this.value);
            }
        }
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String toString() {
        return "Missing restriction " + this.operator + " " + this.value;
    }

    @Override
    public Collection<Cause> getCauses() {
        return null;
    }
}

