/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.List;
import org.drools.drl.ast.descr.AtomicExprDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.drl.parser.DrlExprParser;
import org.drools.drl.parser.impl.Operator;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.FieldVariable;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternEval;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.solver.Solvers;
import org.drools.verifier.visitor.OrderNumber;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class ExprConstraintDescrVisitor {
    private final Pattern pattern;
    private final VerifierData data;
    private final Solvers solvers;
    private final OrderNumber orderNumber;
    private Field field;

    public ExprConstraintDescrVisitor(Pattern pattern, VerifierData data, OrderNumber orderNumber, Solvers solvers) {
        this.pattern = pattern;
        this.data = data;
        this.orderNumber = orderNumber;
        this.solvers = solvers;
    }

    public void visit(ExprConstraintDescr descr) {
        DrlExprParser drlExprParser = new DrlExprParser(LanguageLevelOption.DRL5);
        ConstraintConnectiveDescr constraintConnectiveDescr = drlExprParser.parse(descr.getExpression());
        this.visit(constraintConnectiveDescr.getDescrs());
    }

    private void visit(List<BaseDescr> descrs) {
        for (BaseDescr descr : descrs) {
            this.visit(descr);
        }
    }

    private void visit(RelationalExprDescr descr) {
        int currentOrderNumber = this.orderNumber.next();
        String fieldName = this.visit(descr.getLeft());
        Operator operator = Operator.determineOperator((String)descr.getOperator(), (boolean)descr.isNegated());
        String value = this.visit(descr.getRight());
        this.setField(descr, fieldName);
        if (this.isAVariableRestriction(value)) {
            this.createVariableRestriction(currentOrderNumber, value, operator);
        } else {
            this.createRestriction(currentOrderNumber, value, operator);
        }
    }

    private void createRestriction(int currentOrderNumber, String value, Operator operator) {
        LiteralRestriction restriction = LiteralRestriction.createRestriction(this.pattern, value);
        restriction.setFieldPath(this.field.getPath());
        restriction.setPatternIsNot(this.pattern.isPatternNot());
        restriction.setParentPath(this.pattern.getPath());
        restriction.setParentType(this.pattern.getVerifierComponentType());
        restriction.setOrderNumber(currentOrderNumber);
        restriction.setOperator(operator);
        this.field.setFieldType(restriction.getValueType());
        this.data.add(restriction);
        this.solvers.addPatternComponent(restriction);
    }

    private void setField(RelationalExprDescr descr, String fieldName) {
        this.field = this.data.getFieldByObjectTypeAndFieldName(this.pattern.getName(), fieldName);
        if (this.field == null) {
            this.createField(descr, fieldName);
        }
    }

    private void createField(RelationalExprDescr descr, String fieldName) {
        this.field = new Field((BaseDescr)this.pattern.getDescr());
        this.field.setName(fieldName);
        this.field.setObjectTypePath(this.pattern.getObjectTypePath());
        this.field.setObjectTypeName(this.pattern.getName());
        this.data.add(this.field);
    }

    private String visit(BaseDescr descr) {
        if (descr instanceof AtomicExprDescr) {
            return this.visit((AtomicExprDescr)descr);
        }
        if (descr instanceof ConstraintConnectiveDescr) {
            this.visit((ConstraintConnectiveDescr)descr);
        } else if (descr instanceof RelationalExprDescr) {
            this.visit((RelationalExprDescr)descr);
        } else if (descr instanceof BindingDescr) {
            this.visit((BindingDescr)descr);
        }
        return "";
    }

    private void visit(BindingDescr descr) {
        Field field = new Field((BaseDescr)descr);
        field.setName(descr.getExpression());
        field.setObjectTypeName(this.pattern.getName());
        field.setObjectTypePath(this.pattern.getObjectTypePath());
        this.data.add(field);
        FieldVariable fieldVariable = new FieldVariable(this.pattern);
        fieldVariable.setParentPath(field.getPath());
        fieldVariable.setName(descr.getVariable());
        fieldVariable.setOrderNumber(this.orderNumber.next());
        this.data.add(fieldVariable);
    }

    private void visit(ConstraintConnectiveDescr descr) {
        switch (descr.getConnective()) {
            case AND: {
                this.solvers.startOperator(OperatorDescrType.AND);
                for (BaseDescr baseDescr : descr.getDescrs()) {
                    this.visit(baseDescr);
                }
                this.solvers.endOperator();
                break;
            }
            case OR: {
                this.solvers.startOperator(OperatorDescrType.OR);
                for (BaseDescr baseDescr : descr.getDescrs()) {
                    this.visit(baseDescr);
                }
                this.solvers.endOperator();
                break;
            }
            case XOR: {
                break;
            }
            case INC_OR: {
                break;
            }
        }
    }

    private String visit(AtomicExprDescr descr) {
        String expression = descr.getExpression();
        if (this.isEval(expression)) {
            this.createEval(expression);
        } else if (this.isSurroundedByQuotes(expression)) {
            expression = expression.substring(1, expression.length() - 1);
        }
        return expression;
    }

    private boolean isAVariableRestriction(String value) {
        return this.data.getVariableByRuleAndVariableName(this.pattern.getRuleName(), value) != null;
    }

    private boolean isSurroundedByQuotes(String expression) {
        return this.firstAndLastCharacterIs(expression, '\"') || this.firstAndLastCharacterIs(expression, '\'');
    }

    private boolean isEval(String expression) {
        return expression.trim().startsWith("eval");
    }

    private void createEval(String expression) {
        PatternEval eval = new PatternEval(this.pattern);
        eval.setContent(expression);
        eval.setOrderNumber(this.orderNumber.next());
        eval.setParentPath(this.pattern.getPath());
        eval.setParentType(this.pattern.getVerifierComponentType());
        this.solvers.addPatternComponent(eval);
        this.data.add(eval);
    }

    private boolean firstAndLastCharacterIs(String expression, char character) {
        return expression.charAt(0) == character && expression.charAt(expression.length() - 1) == character;
    }

    private void createVariableRestriction(int orderNumber, String value, Operator operator) {
        Variable variable = this.data.getVariableByRuleAndVariableName(this.pattern.getRuleName(), value);
        VariableRestriction restriction = new VariableRestriction(this.pattern);
        restriction.setPatternIsNot(this.pattern.isPatternNot());
        restriction.setFieldPath(this.field.getPath());
        restriction.setOperator(operator);
        restriction.setVariable(variable);
        restriction.setOrderNumber(orderNumber);
        restriction.setParentPath(this.pattern.getPath());
        restriction.setParentType(this.pattern.getVerifierComponentType());
        this.field.setFieldType("Variable");
        this.data.add(restriction);
        this.solvers.addPatternComponent(restriction);
    }
}

