/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.doc;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class DroolsDocsComponentFactory {
    private static final int INDENTATION_LEFT = 20;
    private static final String INDENT = "    ";
    private static final Font CHAPTER_TITLE = FontFactory.getFont((String)"Times", (float)20.0f, (int)1);
    private static final Font PACKAGE_NAME = FontFactory.getFont((String)"Times", (float)10.0f, (int)1);
    private static final Font RULE_PACKAGE_TITLE = FontFactory.getFont((String)"Times", (float)24.0f, (int)1);
    private static final Font CATEGORIES_TEXT = FontFactory.getFont((String)"Times", (float)12.0f);
    private static final Font BODY_TEXT = FontFactory.getFont((String)"Times", (float)10.0f);
    static final Font HEADER_FOOTER_TEXT = FontFactory.getFont((String)"Times", (float)8.0f);

    public static Table newDescription(String description) throws DocumentException {
        if (description == null || "".equals(description)) {
            description = " - ";
        }
        Table table = DroolsDocsComponentFactory.newTable();
        Cell headerCell = DroolsDocsComponentFactory.newHeaderCell("Description", CATEGORIES_TEXT);
        table.addCell(headerCell);
        table.addCell(DroolsDocsComponentFactory.newCell(description));
        return table;
    }

    private static Table newTable() throws BadElementException {
        Table table = new Table(1);
        table.setBorderWidthTop(1.0f);
        table.setBorderWidthLeft(1.0f);
        table.setBorderWidthRight(1.0f);
        table.setBorderWidthBottom(0.0f);
        table.setWidth(100.0f);
        table.setPadding(3.0f);
        table.setAlignment(0);
        return table;
    }

    public static void createOtherItems(Document document, Map<String, List<String>> other) throws DocumentException {
        for (String key : other.keySet()) {
            document.add((Element)DroolsDocsComponentFactory.newTable(key, (Collection<String>)other.get(key)));
        }
    }

    public static Table newRuleTable(DrlRuleParser drl) throws BadElementException, DocumentException {
        Table table = DroolsDocsComponentFactory.newTable();
        Cell headerCell = DroolsDocsComponentFactory.newHeaderCell("Attributes", CATEGORIES_TEXT);
        table.addCell(headerCell);
        for (String s : drl.getHeader()) {
            table.addCell(DroolsDocsComponentFactory.newCell(INDENT + s.trim()));
        }
        table.addCell(DroolsDocsComponentFactory.newHeaderCell("    WHEN", BODY_TEXT));
        for (String s : drl.getLhs()) {
            table.addCell(DroolsDocsComponentFactory.newCell("        " + s.trim()));
        }
        table.addCell(DroolsDocsComponentFactory.newHeaderCell("    THEN", BODY_TEXT));
        for (String s : drl.getRhs()) {
            table.addCell(DroolsDocsComponentFactory.newCell("        " + s.trim()));
        }
        return table;
    }

    public static Table newTable(String topic, Collection<String> items) throws BadElementException, DocumentException {
        Table table = DroolsDocsComponentFactory.newTable();
        Cell headerCell = DroolsDocsComponentFactory.newHeaderCell(topic, CATEGORIES_TEXT);
        table.addCell(headerCell);
        if (items.isEmpty()) {
            table.addCell(DroolsDocsComponentFactory.newCell(" - "));
        } else {
            for (String s : items) {
                table.addCell(DroolsDocsComponentFactory.newCell(s));
            }
        }
        return table;
    }

    public static com.lowagie.text.List createContents(List<DrlRuleParser> rules) {
        com.lowagie.text.List index = new com.lowagie.text.List(true);
        for (DrlRuleParser drlRuleData : rules) {
            Chunk chunk = new Chunk(drlRuleData.getName());
            ListItem listItem = new ListItem(chunk);
            index.add((Object)listItem);
        }
        return index;
    }

    private static Cell newHeaderCell(String text, Font font) throws BadElementException {
        Cell c = new Cell((Element)new Phrase(text, font));
        c.setBackgroundColor(Color.decode("#CCCCFF"));
        c.setLeading(10.0f);
        c.setBorder(1);
        return c;
    }

    private static Cell newCell(String text) throws BadElementException {
        Cell c = new Cell((Element)new Phrase(text, BODY_TEXT));
        c.setLeading(10.0f);
        c.setBorder(0);
        c.setBorderWidthBottom(1.0f);
        return c;
    }

    public static HeaderFooter createFooter(String packageName) {
        HeaderFooter footer = new HeaderFooter(new Phrase(packageName + "-", HEADER_FOOTER_TEXT), true);
        footer.setBorder(1);
        footer.setAlignment(2);
        return footer;
    }

    private static String[] splitFirst(String source, String splitter) {
        ArrayList<String> rv = new ArrayList<String>();
        int last = 0;
        int next = source.indexOf(splitter, last);
        if (next != -1) {
            rv.add(source.substring(last, next));
            last = next + splitter.length();
        }
        if (last < source.length()) {
            rv.add(source.substring(last));
        }
        return rv.toArray(new String[rv.size()]);
    }

    public static void newRulePage(Document document, String packageName, DrlRuleParser drlData) throws DocumentException {
        document.add((Element)new Paragraph(packageName, PACKAGE_NAME));
        document.add((Element)new Paragraph("Rule " + drlData.getName(), CHAPTER_TITLE));
        int index = drlData.getName().lastIndexOf("extends");
        if (index > 0) {
            document.add((Element)new Paragraph("Extends:", BODY_TEXT));
            Paragraph ext = new Paragraph(drlData.getName().substring("extends".length() + index), BODY_TEXT);
            ext.setIndentationLeft(20.0f);
            document.add((Element)ext);
        }
        if (drlData.getDescription() != null && drlData.getDescription().trim().equals("")) {
            for (String nextDesc : drlData.getMetadata()) {
                if (!nextDesc.startsWith("Description")) continue;
                String[] parts = DroolsDocsComponentFactory.splitFirst(nextDesc, ":");
                if (parts.length == 1) {
                    document.add((Element)DroolsDocsComponentFactory.newDescription(drlData.getDescription()));
                    continue;
                }
                document.add((Element)DroolsDocsComponentFactory.newDescription(parts[1]));
            }
        } else {
            document.add((Element)DroolsDocsComponentFactory.newDescription(drlData.getDescription()));
        }
        document.add((Element)DroolsDocsComponentFactory.newRuleTable(drlData));
        document.add((Element)DroolsDocsComponentFactory.newTable("Metadata", drlData.getMetadata()));
        DroolsDocsComponentFactory.createOtherItems(document, drlData.getOtherInformation());
        document.newPage();
    }

    public static void createFirstPage(Document document, String currentDate, DrlPackageParser packageData) throws DocumentException {
        Paragraph title = new Paragraph("\n\n\n\n\n" + packageData.getName().toUpperCase(), RULE_PACKAGE_TITLE);
        title.setAlignment(1);
        document.add((Element)title);
        Paragraph date = new Paragraph("Documentation created: " + currentDate, BODY_TEXT);
        date.setAlignment(1);
        document.add((Element)date);
        document.add((Element)new Paragraph("\n\n\n\n\n" + packageData.getDescription(), BODY_TEXT));
        document.add((Element)DroolsDocsComponentFactory.newTable("Metadata ", packageData.getMetadata()));
        document.add((Element)DroolsDocsComponentFactory.newTable("Globals ", packageData.getGlobals()));
        DroolsDocsComponentFactory.createOtherItems(document, packageData.getOtherInformation());
    }
}

