/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.doc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class DroolsDocsComponentFactory {
    private static final String INDENT = "    ";

    public static void createToC(PDDocument doc, int pageNumber, DrlPackageParser packageData) throws IOException {
        PDPage page = new PDPage(PDRectangle.A4);
        float yPosition = page.getMediaBox().getHeight() - 50.0f;
        doc.addPage(page);
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
            StringBuilder sb = new StringBuilder("Table of Contents\n");
            int count = 0;
            for (DrlRuleParser rule : packageData.getRules()) {
                sb.append(++count).append(". ").append(rule.getName().replaceAll("\"", "")).append("\n");
            }
            DroolsDocsComponentFactory.drawText(contentStream, page, yPosition, 15, sb.toString());
            DroolsDocsComponentFactory.addFooter(contentStream, page, pageNumber, packageData.getName());
        }
    }

    public static void createRulePage(PDDocument doc, int pageNumber, String packageName, DrlRuleParser drlData) throws IOException {
        PDPage page = new PDPage(PDRectangle.A4);
        doc.addPage(page);
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
            DroolsDocsComponentFactory.createHeader(contentStream, page, packageName);
            float yPosition = DroolsDocsComponentFactory.createRuleHeader(contentStream, page, drlData.getName().replaceAll("\"", ""));
            int extendIndex = drlData.getName().lastIndexOf("extends");
            if (extendIndex > 0) {
                yPosition = DroolsDocsComponentFactory.drawText(contentStream, page, yPosition + 20.0f, 12, "Extends: " + drlData.getName().substring("extends".length() + extendIndex).replaceAll("\"", ""));
            }
            yPosition = !drlData.getDescription().trim().isEmpty() ? DroolsDocsComponentFactory.createTable(contentStream, page, yPosition, Map.of("Description", List.of(drlData.getDescription()))) : (yPosition += 40.0f);
            LinkedHashMap<String, Collection<String>> content = new LinkedHashMap<String, Collection<String>>();
            content.put("Attributes", DroolsDocsComponentFactory.dashIfEmpty(DroolsDocsComponentFactory.prefix(INDENT, drlData.getHeader())));
            content.put("    WHEN", DroolsDocsComponentFactory.dashIfEmpty(DroolsDocsComponentFactory.prefix("        ", drlData.getLhs())));
            content.put("    THEN", DroolsDocsComponentFactory.dashIfEmpty(DroolsDocsComponentFactory.prefix("        ", drlData.getRhs())));
            yPosition = DroolsDocsComponentFactory.createTable(contentStream, page, yPosition - 40.0f, content);
            DroolsDocsComponentFactory.createTable(contentStream, page, yPosition - 40.0f, Map.of("Metadata", DroolsDocsComponentFactory.dashIfEmpty(drlData.getMetadata())));
            DroolsDocsComponentFactory.createOtherItems(contentStream, page, yPosition, drlData.getOtherInformation());
            DroolsDocsComponentFactory.addFooter(contentStream, page, pageNumber, packageName);
        }
    }

    private static Collection<String> prefix(String prefix, Collection<String> input) {
        ArrayList<String> result = new ArrayList<String>(input.size());
        for (String s : input) {
            result.add(prefix + s.replaceAll("\t", INDENT));
        }
        return result;
    }

    private static Collection<String> dashIfEmpty(Collection<String> input) {
        return input.isEmpty() ? List.of("-") : input;
    }

    private static float createRuleHeader(PDPageContentStream contentStream, PDPage page, String string) throws IOException {
        float yPosition = page.getMediaBox().getHeight() - 50.0f;
        return DroolsDocsComponentFactory.drawText(contentStream, page, yPosition, (PDFont)PDType1Font.TIMES_BOLD, 20, "Rule " + string);
    }

    public static void createFirstPage(PDDocument doc, String date, DrlPackageParser packageData) throws IOException {
        PDPage page = new PDPage(PDRectangle.A4);
        doc.addPage(page);
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
            float lastContentY = DroolsDocsComponentFactory.writeCenteredTitleAndDate(contentStream, page, packageData.getName().toUpperCase(), date);
            lastContentY = DroolsDocsComponentFactory.drawText(contentStream, page, lastContentY, 10, "\n\n\n\n\n" + packageData.getDescription());
            lastContentY = DroolsDocsComponentFactory.createTable(contentStream, page, lastContentY, Map.of("Metadata", packageData.getMetadata().isEmpty() ? List.of("-") : packageData.getMetadata()));
            lastContentY = DroolsDocsComponentFactory.createTable(contentStream, page, lastContentY - 20.0f, Map.of("Globals", packageData.getGlobals()));
            DroolsDocsComponentFactory.createOtherItems(contentStream, page, lastContentY, packageData.getOtherInformation());
            DroolsDocsComponentFactory.addFooter(contentStream, page, 1, packageData.getName());
        }
    }

    private static float createOtherItems(PDPageContentStream contentStream, PDPage page, float lastContentY, Map<String, List<String>> otherInformation) throws IOException {
        for (Map.Entry<String, List<String>> other : otherInformation.entrySet()) {
            lastContentY = DroolsDocsComponentFactory.createTable(contentStream, page, lastContentY - 20.0f, Map.of(other.getKey(), (Collection)other.getValue()));
        }
        return lastContentY;
    }

    private static void addFooter(PDPageContentStream contentStream, PDPage page, int pageNumber, String footerText) throws IOException {
        contentStream.moveTo(50.0f, 50.0f);
        contentStream.lineTo(page.getMediaBox().getWidth() - 50.0f, 50.0f);
        contentStream.stroke();
        String text = footerText + " - " + pageNumber;
        int fontSize = 8;
        float width = PDType1Font.TIMES_ROMAN.getStringWidth(text) / 1000.0f * (float)fontSize;
        float pageWidth = page.getMediaBox().getWidth();
        float xPosition = pageWidth - width - 50.0f;
        contentStream.beginText();
        contentStream.setFont((PDFont)PDType1Font.TIMES_ROMAN, (float)fontSize);
        contentStream.newLineAtOffset(xPosition, 40.0f);
        contentStream.showText(text);
        contentStream.endText();
    }

    private static float createTable(PDPageContentStream contentStream, PDPage page, float yPosition, Map<String, Collection<String>> icontent) throws IOException {
        float margin = 50.0f;
        float tableWidth = page.getMediaBox().getWidth() - 2.0f * margin;
        float tableRowHeight = 20.0f;
        float colWidth = tableWidth;
        float contentY = 0.0f;
        float tableTopY = yPosition;
        float tableBottomY = 0.0f;
        for (Map.Entry<String, Collection<String>> entry : icontent.entrySet()) {
            String header = entry.getKey();
            Collection<String> content = entry.getValue();
            float headerY = DroolsDocsComponentFactory.drawRow(contentStream, page, header, yPosition, tableWidth, tableRowHeight, colWidth, true);
            DroolsDocsComponentFactory.drawLine(contentStream, margin, headerY, margin + tableWidth, headerY);
            contentY = headerY;
            for (String rowContent : content) {
                contentY = DroolsDocsComponentFactory.drawRow(contentStream, page, rowContent, contentY, tableWidth, tableRowHeight, colWidth, false);
                DroolsDocsComponentFactory.drawLine(contentStream, margin, contentY, margin + tableWidth, contentY);
            }
            yPosition = contentY;
        }
        tableBottomY = yPosition;
        DroolsDocsComponentFactory.drawLine(contentStream, margin, tableTopY, margin + tableWidth, tableTopY);
        DroolsDocsComponentFactory.drawLine(contentStream, margin, tableBottomY, margin + tableWidth, tableBottomY);
        DroolsDocsComponentFactory.drawLine(contentStream, margin, tableTopY, margin, tableBottomY);
        DroolsDocsComponentFactory.drawLine(contentStream, margin + colWidth, tableTopY, margin + colWidth, tableBottomY);
        return contentY;
    }

    private static void drawLine(PDPageContentStream contentStream, float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        contentStream.moveTo(xStart, yStart);
        contentStream.lineTo(xEnd, yEnd);
        contentStream.stroke();
    }

    private static float drawRow(PDPageContentStream contentStream, PDPage page, String text, float yPosition, float tableWidth, float rowHeight, float colWidth, boolean header) throws IOException {
        float margin = 50.0f;
        float textx = margin + 5.0f;
        String[] lines = text.split("\n");
        float currentY = yPosition;
        if (header) {
            PDColor headerBgColor = new PDColor(new float[]{0.8f, 0.8f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            contentStream.setNonStrokingColor(headerBgColor);
            contentStream.addRect(margin, currentY - rowHeight * (float)lines.length, tableWidth, rowHeight * (float)lines.length);
            contentStream.fill();
            contentStream.setNonStrokingColor(new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            contentStream.setFont((PDFont)PDType1Font.TIMES_ROMAN, 12.0f);
        } else {
            contentStream.setFont((PDFont)PDType1Font.TIMES_ROMAN, 10.0f);
        }
        for (String line : lines) {
            contentStream.beginText();
            contentStream.newLineAtOffset(textx, currentY - 15.0f);
            contentStream.showText(line);
            contentStream.endText();
            currentY -= rowHeight;
        }
        return currentY;
    }

    private static float drawText(PDPageContentStream contentStream, PDPage page, float yPosition, int fontSize, String text) throws IOException {
        return DroolsDocsComponentFactory.drawText(contentStream, page, yPosition, (PDFont)PDType1Font.TIMES_ROMAN, fontSize, text);
    }

    private static float drawText(PDPageContentStream contentStream, PDPage page, float yPosition, PDFont font, int fontSize, String text) throws IOException {
        float margin = 50.0f;
        float textx = margin + 5.0f;
        float currentY = yPosition;
        float height = (float)fontSize + 5.0f;
        contentStream.setFont(font, (float)fontSize);
        for (String line : text.split("\n")) {
            contentStream.beginText();
            contentStream.newLineAtOffset(textx, currentY - ((float)fontSize + 5.0f));
            contentStream.showText(line);
            contentStream.endText();
            currentY -= height;
        }
        return currentY - height;
    }

    private static float writeCenteredTitleAndDate(PDPageContentStream contentStream, PDPage page, String title, String currentDate) throws IOException {
        float yStart = page.getMediaBox().getHeight() / 3.0f * 2.0f;
        float xStart = page.getMediaBox().getWidth() / 2.0f;
        float titleFontSize = 24.0f;
        float dateFontSize = 10.0f;
        float titleWidth = PDType1Font.TIMES_BOLD.getStringWidth(title) / 1000.0f * titleFontSize;
        float titleX = xStart - titleWidth / 2.0f;
        float titleY = yStart;
        contentStream.setFont((PDFont)PDType1Font.TIMES_BOLD, titleFontSize);
        contentStream.beginText();
        contentStream.newLineAtOffset(titleX, titleY);
        contentStream.showText(title);
        contentStream.endText();
        String textContent = "Documentation created: " + currentDate;
        float dateWidth = PDType1Font.TIMES_ROMAN.getStringWidth(textContent) / 1000.0f * dateFontSize;
        float dateX = xStart - dateWidth / 2.0f;
        float dateY = yStart - titleFontSize + 5.0f;
        contentStream.setFont((PDFont)PDType1Font.TIMES_ROMAN, dateFontSize);
        contentStream.beginText();
        contentStream.newLineAtOffset(dateX, dateY);
        contentStream.showText(textContent);
        contentStream.endText();
        return dateY;
    }

    private static void createHeader(PDPageContentStream contentStream, PDPage page, String header) throws IOException {
        float margin = 40.0f;
        float headerFontSize = 10.0f;
        float xPosition = margin;
        float yPosition = page.getMediaBox().getHeight() - margin;
        contentStream.setFont((PDFont)PDType1Font.TIMES_BOLD, headerFontSize);
        contentStream.beginText();
        contentStream.newLineAtOffset(xPosition, yPosition);
        contentStream.showText(header);
        contentStream.endText();
    }
}

