/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.DataFormatException;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.report.components.Cause;

public class LiteralRestriction
extends Restriction
implements Cause {
    private Field.FieldType valueType;
    private boolean booleanValue;
    private int intValue;
    private double doubleValue;
    private String stringValue;
    private Date dateValue;

    public Restriction.RestrictionType getRestrictionType() {
        return Restriction.RestrictionType.LITERAL;
    }

    public int compareValues(LiteralRestriction restriction) throws DataFormatException {
        if (restriction.getValueType() != this.valueType) {
            throw new DataFormatException("Value types did not match. Value type " + restriction.getValueType() + " was compared to " + this.valueType);
        }
        if (this.valueType == Field.FieldType.DATE) {
            return this.dateValue.compareTo(restriction.getDateValue());
        }
        if (this.valueType == Field.FieldType.DOUBLE) {
            if (this.doubleValue > restriction.getDoubleValue()) {
                return 1;
            }
            if (this.doubleValue < restriction.getDoubleValue()) {
                return -1;
            }
            return 0;
        }
        if (this.valueType == Field.FieldType.INT) {
            if (this.intValue > restriction.getIntValue()) {
                return 1;
            }
            if (this.intValue < restriction.getIntValue()) {
                return -1;
            }
            return 0;
        }
        if (this.valueType == Field.FieldType.STRING) {
            return this.stringValue.compareTo(restriction.getValueAsString());
        }
        if (this.valueType == Field.FieldType.UNKNOWN) {
            return 0;
        }
        throw new DataFormatException("Value types did not match. Value type " + restriction.getValueType() + " was compared to " + this.valueType);
    }

    public Object getValueAsObject() {
        if (this.valueType == Field.FieldType.BOOLEAN) {
            return this.booleanValue;
        }
        if (this.valueType == Field.FieldType.DATE) {
            return this.dateValue;
        }
        if (this.valueType == Field.FieldType.DOUBLE) {
            return this.doubleValue;
        }
        if (this.valueType == Field.FieldType.INT) {
            return this.intValue;
        }
        return this.stringValue;
    }

    public String getValueAsString() {
        return this.stringValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public Field.FieldType getValueType() {
        return this.valueType;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setValue(String value) {
        if (value == null) {
            this.stringValue = null;
            this.valueType = Field.FieldType.UNKNOWN;
            return;
        }
        this.stringValue = value;
        this.valueType = Field.FieldType.STRING;
        if ("true".equals(value) || "false".equals(value)) {
            this.booleanValue = value.equals("true");
            this.valueType = Field.FieldType.BOOLEAN;
            this.stringValue = value;
        }
        try {
            this.intValue = Integer.parseInt(value);
            this.valueType = Field.FieldType.INT;
            this.stringValue = value;
            return;
        }
        catch (NumberFormatException e) {
            try {
                this.doubleValue = Double.parseDouble(value);
                this.valueType = Field.FieldType.DOUBLE;
                this.stringValue = value;
                return;
            }
            catch (NumberFormatException e2) {
                try {
                    String fmt = System.getProperty("drools.dateformat");
                    if (fmt == null) {
                        fmt = "dd-MMM-yyyy";
                    }
                    this.dateValue = new SimpleDateFormat(fmt, Locale.ENGLISH).parse(value);
                    this.valueType = Field.FieldType.DATE;
                    this.stringValue = value;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public String toString() {
        return "LiteralRestriction from rule [" + this.ruleName + "] value '" + this.operator.getOperatorString() + " " + this.stringValue + "'";
    }
}

