/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.data;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.drools.verifier.components.EntryPoint;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierDataMaps
implements VerifierData {
    private Map<VerifierComponentType, Map<String, VerifierComponent>> all = new TreeMap<VerifierComponentType, Map<String, VerifierComponent>>();
    private Map<String, RulePackage> packagesByName = new TreeMap<String, RulePackage>();
    private Map<String, ObjectType> objectTypesByFullName = new TreeMap<String, ObjectType>();
    private Map<String, Field> fieldsByObjectTypeAndFieldName = new TreeMap<String, Field>();
    private Multimap<String, Field> fieldsByObjectTypeId = new TreeMultimap();
    private Multimap<String, Pattern> patternsByObjectTypeId = new TreeMultimap();
    private Multimap<String, Pattern> patternsByRuleName = new TreeMultimap();
    private Multimap<String, Restriction> restrictionsByFieldId = new TreeMultimap();
    private Map<String, Variable> variablesByRuleAndVariableName = new TreeMap<String, Variable>();
    private Map<String, EntryPoint> entryPointsByEntryId = new TreeMap<String, EntryPoint>();
    private Map<String, VerifierRule> rulesByName = new TreeMap<String, VerifierRule>();
    private Map<String, Import> importsByName = new TreeMap<String, Import>();
    private Multimap<String, VerifierRule> rulesByCategory = new TreeMultimap();

    VerifierDataMaps() {
    }

    @Override
    public Collection<ObjectType> getObjectTypesByRuleName(String ruleName) {
        HashSet<ObjectType> set = new HashSet<ObjectType>();
        for (Pattern pattern : this.patternsByRuleName.get((Object)ruleName)) {
            ObjectType objectType = (ObjectType)this.getVerifierObject(VerifierComponentType.OBJECT_TYPE, pattern.getObjectTypePath());
            set.add(objectType);
        }
        return set;
    }

    @Override
    public ObjectType getObjectTypeByFullName(String name) {
        return this.objectTypesByFullName.get(name);
    }

    @Override
    public Field getFieldByObjectTypeAndFieldName(String objectTypeName, String fieldName) {
        return this.fieldsByObjectTypeAndFieldName.get(objectTypeName + "." + fieldName);
    }

    @Override
    public Variable getVariableByRuleAndVariableName(String ruleName, String variableName) {
        return this.variablesByRuleAndVariableName.get(ruleName + "." + variableName);
    }

    @Override
    public Collection<VerifierComponent> getAll() {
        ArrayList<VerifierComponent> objects = new ArrayList<VerifierComponent>();
        for (VerifierComponentType type : this.all.keySet()) {
            objects.addAll(this.all.get(type).values());
        }
        return objects;
    }

    public Collection<Field> getFieldsByObjectTypeId(String id) {
        return this.fieldsByObjectTypeId.get((Object)id);
    }

    @Override
    public Collection<VerifierRule> getRulesByObjectTypePath(String id) {
        HashSet<VerifierRule> rules = new HashSet<VerifierRule>();
        for (Pattern pattern : this.patternsByObjectTypeId.get((Object)id)) {
            rules.add((VerifierRule)this.getVerifierObject(VerifierComponentType.RULE, pattern.getRulePath()));
        }
        return rules;
    }

    @Override
    public Collection<VerifierRule> getRulesByFieldPath(String id) {
        HashSet<VerifierRule> rules = new HashSet<VerifierRule>();
        for (Restriction restriction : this.restrictionsByFieldId.get((Object)id)) {
            rules.add((VerifierRule)this.getVerifierObject(VerifierComponentType.RULE, restriction.getRulePath()));
        }
        return rules;
    }

    @Override
    public RulePackage getPackageByName(String name) {
        return this.packagesByName.get(name);
    }

    @Override
    public Collection<Restriction> getRestrictionsByFieldPath(String id) {
        return this.restrictionsByFieldId.get((Object)id);
    }

    @Override
    public void add(VerifierComponent object) {
        if (VerifierComponentType.FIELD.equals(object.getVerifierComponentType())) {
            Field field = (Field)object;
            ObjectType objectType = (ObjectType)this.getVerifierObject(VerifierComponentType.OBJECT_TYPE, field.getObjectTypePath());
            this.fieldsByObjectTypeAndFieldName.put(objectType.getFullName() + "." + field.getName(), field);
            this.fieldsByObjectTypeId.put((Object)field.getObjectTypePath(), (Object)field);
        } else if (VerifierComponentType.RULE.equals(object.getVerifierComponentType())) {
            VerifierRule rule = (VerifierRule)object;
            this.rulesByName.put(rule.getName(), rule);
            if (rule.getMetadata().containsKey("category")) {
                this.rulesByCategory.put((Object)rule.getMetadata().get("category"), (Object)rule);
            }
        } else if (VerifierComponentType.VARIABLE.equals(object.getVerifierComponentType())) {
            Variable variable = (Variable)object;
            this.variablesByRuleAndVariableName.put(variable.getRuleName() + "." + variable.getName(), variable);
        } else if (VerifierComponentType.PATTERN.equals(object.getVerifierComponentType())) {
            Pattern pattern = (Pattern)object;
            this.patternsByObjectTypeId.put((Object)pattern.getObjectTypePath(), (Object)pattern);
            this.patternsByRuleName.put((Object)pattern.getRuleName(), (Object)pattern);
        } else if (VerifierComponentType.RESTRICTION.equals(object.getVerifierComponentType())) {
            Restriction restriction = (Restriction)object;
            this.restrictionsByFieldId.put((Object)restriction.getFieldPath(), (Object)restriction);
        } else if (VerifierComponentType.RULE_PACKAGE.equals(object.getVerifierComponentType())) {
            RulePackage rulePackage = (RulePackage)object;
            this.packagesByName.put(rulePackage.getName(), rulePackage);
        } else if (VerifierComponentType.IMPORT.equals(object.getVerifierComponentType())) {
            Import objectImport = (Import)object;
            this.importsByName.put(objectImport.getName(), objectImport);
        } else if (VerifierComponentType.OBJECT_TYPE.equals(object.getVerifierComponentType())) {
            ObjectType objectType = (ObjectType)object;
            this.objectTypesByFullName.put(objectType.getFullName(), objectType);
        } else if (VerifierComponentType.ENTRY_POINT_DESCR.equals(object.getVerifierComponentType())) {
            EntryPoint entryPoint = (EntryPoint)object;
            this.entryPointsByEntryId.put(entryPoint.getEntryPointName(), entryPoint);
        }
        Map<String, VerifierComponent> map = this.all.get(object.getVerifierComponentType());
        if (map == null) {
            map = new TreeMap<String, VerifierComponent>();
            this.all.put(object.getVerifierComponentType(), map);
        }
        String path = object.getPath();
        map.put(path, object);
    }

    @Override
    public Collection<VerifierRule> getRulesByCategoryName(String categoryName) {
        return this.rulesByCategory.get((Object)categoryName);
    }

    public Collection<? extends VerifierComponent> getAll(VerifierComponentType type) {
        Map<String, VerifierComponent> result = this.all.get(type);
        if (result == null) {
            return Collections.emptyList();
        }
        return result.values();
    }

    public VerifierComponent getVerifierObject(VerifierComponentType type, String path) {
        return this.all.get(type).get(path);
    }

    @Override
    public EntryPoint getEntryPointByEntryId(String entryId) {
        return this.entryPointsByEntryId.get(entryId);
    }

    @Override
    public VerifierRule getRuleByName(String name) {
        return this.rulesByName.get(name);
    }

    @Override
    public Import getImportByName(String name) {
        return this.importsByName.get(name);
    }

    @Override
    public ObjectType getObjectTypeByObjectTypeNameAndPackageName(String factTypeName, String packageName) {
        for (VerifierComponent verifierComponent : this.getAll(VerifierComponentType.IMPORT)) {
            Import objectImport = (Import)verifierComponent;
            if (!objectImport.getPackageName().equals(packageName) || !objectImport.getShortName().equals(factTypeName)) continue;
            return this.objectTypesByFullName.get(objectImport.getName());
        }
        return null;
    }
}

