/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import org.drools.verifier.components.ChildComponent;
import org.drools.verifier.components.PackageComponent;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;

public abstract class RuleComponent
extends PackageComponent
implements ChildComponent {
    private String ruleName;
    private VerifierComponentType parentType;
    private String parentPath;
    private int orderNumber;

    public RuleComponent(VerifierRule rule) {
        this(rule.getPackageName(), rule.getName());
    }

    RuleComponent(String packageName, String ruleName) {
        super(packageName);
        this.setRuleName(ruleName);
    }

    public String getFullRulePath() {
        return String.valueOf(this.getPackageName()) + "." + this.getRuleName();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    protected void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRulePath() {
        return String.format("%s.rule[name=%s]", this.getPackagePath(), this.getRuleName());
    }

    public String getPath() {
        return String.format("%s.ruleComponent[%s]", this.getRulePath(), this.getOrderNumber());
    }

    public VerifierComponentType getParentType() {
        return this.parentType;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public void setParentType(VerifierComponentType parentType) {
        this.parentType = parentType;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }
}

