/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.Collections;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.visitor.ObjectTypeFactory;
import org.drools.verifier.visitor.RuleDescrVisitor;
import org.drools.verifier.visitor.TypeDeclarationDescrVisitor;
import org.drools.verifier.visitor.UnknownDescriptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDescrVisitor {
    private final VerifierData data;
    private List<JarInputStream> jars = null;
    private RulePackage rulePackage;

    public PackageDescrVisitor(VerifierData data, List<JarInputStream> jars) {
        this.data = data;
        this.jars = jars;
    }

    public void visitPackageDescr(PackageDescr descr) throws UnknownDescriptionException {
        this.rulePackage = this.data.getPackageByName(descr.getName());
        if (this.rulePackage == null) {
            this.rulePackage = new RulePackage();
            this.rulePackage.setName(descr.getName());
            this.data.add(this.rulePackage);
        }
        this.visitImports(descr.getImports());
        TypeDeclarationDescrVisitor typeDeclarationDescrVisitor = new TypeDeclarationDescrVisitor(this.data);
        typeDeclarationDescrVisitor.visit(descr.getTypeDeclarations());
        this.visitRules(descr.getRules());
    }

    private void visitImports(List<ImportDescr> importDescrs) {
        StringBuilder header = new StringBuilder();
        for (ImportDescr i : importDescrs) {
            String fullPath = i.getTarget();
            String name = fullPath.substring(fullPath.lastIndexOf(".") + 1);
            header.append("import ");
            header.append(fullPath);
            header.append("\n");
            Import objectImport = new Import(this.rulePackage);
            objectImport.setName(fullPath);
            objectImport.setShortName(name);
            this.data.add(objectImport);
            ObjectType objectType = this.data.getObjectTypeByFullName(fullPath);
            if (objectType == null) {
                objectType = new ObjectType();
            }
            objectType.setName(name);
            objectType.setFullName(fullPath);
            this.data.add(objectType);
        }
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(header.toString(), this.jars, Collections.EMPTY_LIST);
        String[] stringArray = engine.getFactTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String factTypeName = stringArray[n2];
            String[] stringArray2 = engine.getFieldCompletions(factTypeName);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String fieldName = stringArray2[n4];
                ObjectType objectType = this.data.getObjectTypeByObjectTypeNameAndPackageName(factTypeName, this.rulePackage.getName());
                Field field = this.data.getFieldByObjectTypeAndFieldName(objectType.getFullName(), fieldName);
                if (field == null) {
                    field = ObjectTypeFactory.createField(fieldName, objectType);
                    field.setFieldType(engine.getFieldType(objectType.getName(), fieldName));
                    this.data.add(field);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void visitRules(List<RuleDescr> rules) throws UnknownDescriptionException {
        for (RuleDescr ruleDescr : rules) {
            this.visitRuleDescr(ruleDescr);
        }
    }

    private void visitRuleDescr(RuleDescr descr) throws UnknownDescriptionException {
        RuleDescrVisitor visitor = new RuleDescrVisitor(this.data, this.rulePackage);
        visitor.visitRuleDescr(descr);
    }
}

