/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.AgendaFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopesAgendaFilter
implements AgendaFilter {
    public static final String VERIFYING_SCOPE_SINGLE_RULE = "single-rule";
    public static final String VERIFYING_SCOPE_DECISION_TABLE = "decision-table";
    public static final String VERIFYING_SCOPE_KNOWLEDGE_PACKAGE = "knowledge-package";
    public static final Collection<String> ALL_SCOPES = new ArrayList<String>(){
        private static final long serialVersionUID = 510L;
        {
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_DECISION_TABLE);
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_SINGLE_RULE);
            this.add(ScopesAgendaFilter.VERIFYING_SCOPE_KNOWLEDGE_PACKAGE);
        }
    };
    public static final String VERIFYING_SCOPES = "verifying_scopes";
    private final boolean acceptEmpty;
    private final Collection<String> scopes;

    public ScopesAgendaFilter(boolean acceptEmpty, Collection<String> scopes) {
        this.acceptEmpty = acceptEmpty;
        this.scopes = scopes;
    }

    public ScopesAgendaFilter(boolean acceptEmpty, String scope) {
        this.acceptEmpty = acceptEmpty;
        ArrayList<String> list = new ArrayList<String>();
        list.add(scope);
        this.scopes = list;
    }

    public boolean accept(Activation activation) {
        if (this.acceptEmpty && activation.getRule().listMetaAttributes().isEmpty()) {
            return true;
        }
        if (activation.getRule().listMetaAttributes().contains(VERIFYING_SCOPES)) {
            String[] values;
            for (String value : values = activation.getRule().getMetaAttribute(VERIFYING_SCOPES).split(",")) {
                if (!this.scopes.contains(value.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

