/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.drools.base.evaluators.Operator;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.NumberRestriction;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.report.components.MissingRange;
import org.drools.verifier.report.components.VerifierRangeCheckMessage;
import org.drools.verifier.report.html.DataRow;
import org.drools.verifier.report.html.ReportVisitor;
import org.drools.verifier.report.html.UrlFactory;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MissingRangesReportVisitor
extends ReportVisitor {
    MissingRangesReportVisitor() {
    }

    public static Collection<String> visitRestrictionsCollection(String sourceFolder, Collection<Restriction> restrictions, Collection<MissingRange> causes) {
        TreeMultimap dt = new TreeMultimap();
        ArrayList<String> stringRows = new ArrayList<String>();
        for (MissingRange cause : causes) {
            dt.put((Object)cause.getValueAsString(), (Object)new DataRow(null, null, cause.getOperator(), cause.getValueAsString()));
        }
        for (Restriction r : restrictions) {
            if (!(r instanceof NumberRestriction)) continue;
            try {
                NumberRestriction restriction = (NumberRestriction)r;
                dt.put((Object)restriction.getValue().toString(), (Object)new DataRow(restriction.getRulePath(), restriction.getRuleName(), restriction.getOperator(), restriction.getValueAsString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataRow previous = null;
        Iterator iterator = dt.values().iterator();
        while (iterator.hasNext()) {
            DataRow current = (DataRow)iterator.next();
            if (previous != null) {
                if (!(previous.ruleId != null || current.ruleId != null || previous.operator.equals((Object)Operator.EQUAL) || previous.operator.equals((Object)Operator.NOT_EQUAL) || current.operator.equals((Object)Operator.EQUAL) || current.operator.equals((Object)Operator.NOT_EQUAL))) {
                    stringRows.add("Missing : " + previous + " .. " + current);
                    if (iterator.hasNext()) {
                        current = (DataRow)iterator.next();
                    }
                } else if (previous.ruleId != null && previous.ruleId.equals(current.ruleId)) {
                    stringRows.add(UrlFactory.getRuleUrl(sourceFolder, current.ruleId, current.ruleName) + " : " + previous.toString() + " " + current.toString());
                    if (iterator.hasNext()) {
                        current = (DataRow)iterator.next();
                    }
                } else if (!iterator.hasNext()) {
                    MissingRangesReportVisitor.processRangeOutput(previous, stringRows, sourceFolder);
                    MissingRangesReportVisitor.processRangeOutput(current, stringRows, sourceFolder);
                } else {
                    MissingRangesReportVisitor.processRangeOutput(previous, stringRows, sourceFolder);
                }
            } else if (!iterator.hasNext()) {
                MissingRangesReportVisitor.processRangeOutput(current, stringRows, sourceFolder);
            }
            previous = current;
        }
        return stringRows;
    }

    public static String visitRanges(String sourceFolder, Collection<Restriction> restrictions, Collection<MissingRange> collection) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        map.put("lines", MissingRangesReportVisitor.visitRestrictionsCollection(sourceFolder, restrictions, collection));
        String myTemplate = MissingRangesReportVisitor.readFile("ranges.htm");
        String result = String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
        return result;
    }

    private static void processRangeOutput(DataRow dataRow, Collection<String> stringRows, String sourceFolder) {
        if (dataRow.ruleId == null) {
            stringRows.add("Missing : " + dataRow.toString());
        } else {
            stringRows.add(UrlFactory.getRuleUrl(sourceFolder, dataRow.ruleId, dataRow.ruleName) + " : " + dataRow.toString());
        }
    }

    public static String visitRangeCheckMessage(String sourceFolder, VerifierRangeCheckMessage message, VerifierData data) {
        Field field = (Field)message.getFaulty();
        Collection<Restriction> restrictions = data.getRestrictionsByFieldPath(field.getPath());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", MissingRangesReportVisitor.processHeader(sourceFolder));
        map.put("sourceFolder", sourceFolder);
        map.put("fieldFolder", sourceFolder + "/" + "fields");
        map.put("objectTypeFolder", sourceFolder + "/" + "objectTypes");
        map.put("packageFolder", sourceFolder + "/" + "packages");
        map.put("cssStyle", MissingRangesReportVisitor.createStyleTag(sourceFolder + "/" + "css" + "/" + "basic.css"));
        map.put("field", field);
        map.put("objectType", data.getVerifierObject(VerifierComponentType.OBJECT_TYPE, field.getObjectTypePath()));
        map.put("ranges", MissingRangesReportVisitor.visitRanges(".", restrictions, message.getMissingRanges()));
        String myTemplate = MissingRangesReportVisitor.readFile("missingRange.htm");
        String result = String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
        return result;
    }
}

