/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.jarloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.rule.MapBackedClassLoader;

public class VerifierMapBackedClassLoader
extends MapBackedClassLoader {
    public VerifierMapBackedClassLoader(Collection<JarInputStream> jarInputStreams) throws IOException {
        super(VerifierMapBackedClassLoader.createClassLoader(null));
        this.initialize(jarInputStreams);
    }

    private static ClassLoader createClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = VerifierMapBackedClassLoader.class.getClassLoader();
        }
        return classLoader;
    }

    private void initialize(Collection<JarInputStream> jarInputStreams) throws IOException {
        for (JarInputStream jarInputStream : jarInputStreams) {
            this.readJarEntriesToClassLoader(jarInputStream);
        }
    }

    private void readJarEntriesToClassLoader(JarInputStream jarInputStream) throws IOException {
        JarEntry entry;
        byte[] buf = new byte[1024];
        while ((entry = jarInputStream.getNextJarEntry()) != null) {
            int len;
            if (!this.isValidClassEntry(entry)) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jarInputStream.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            this.addResource(entry.getName(), out.toByteArray());
            out.close();
        }
    }

    private boolean isValidClassEntry(JarEntry entry) {
        return !entry.isDirectory() && entry.getName().endsWith(".class");
    }
}

