/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.kie.api.io.Resource;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class VerifierKnowledgeBaseBuilder {
    private List<VerifierError> errors = new ArrayList<VerifierError>();

    public KnowledgeBase newVerifierKnowledgeBase(VerifierConfiguration configuration) {
        KnowledgeBase verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilderConfiguration kbuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbuilderConfiguration.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConfiguration);
        if (configuration.getVerifyingResources() != null) {
            for (Resource resource : configuration.getVerifyingResources().keySet()) {
                kbuilder.add(resource, configuration.getVerifyingResources().get(resource));
            }
        }
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                this.errors.add(new VerifierError("Error compiling verifier rules: " + ((KnowledgeBuilderError)errors.next()).getMessage()));
            }
        }
        verifierKnowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return verifierKnowledgeBase;
    }

    public List<VerifierError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

