/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import java.util.Collection;
import java.util.UUID;
import org.drools.KnowledgeBase;
import org.drools.command.Command;
import org.drools.command.FinishedCommand;
import org.drools.command.KnowledgeBaseAddKnowledgePackagesCommand;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.NewStatefulKnowledgeSessionCommand;
import org.drools.command.SetVariableCommand;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.definition.rule.Rule;
import org.drools.definition.type.FactType;
import org.drools.event.knowledgebase.KnowledgeBaseEventListener;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.vsm.CollectionClient;
import org.drools.vsm.Message;
import org.drools.vsm.ServiceManagerClient;
import org.drools.vsm.StatefulKnowledgeSessionClient;
import org.drools.vsm.responsehandlers.BlockingMessageResponseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBaseClient
implements KnowledgeBase {
    private ServiceManagerClient serviceManager;
    private String instanceId;

    public KnowledgeBaseClient(String instanceId, ServiceManagerClient serviceManager) {
        this.instanceId = instanceId;
        this.serviceManager = serviceManager;
    }

    public void addKnowledgePackages(Collection<KnowledgePackage> kpackages) {
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        String kuilderInstanceId = ((CollectionClient)kpackages).getParentInstanceId();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new KnowledgeBaseAddKnowledgePackagesCommand(), kuilderInstanceId, this.instanceId, null, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (!(object instanceof FinishedCommand)) {
                throw new RuntimeException("Response was not correctly ended");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public FactType getFactType(String packageName, String typeName) {
        return null;
    }

    public KnowledgePackage getKnowledgePackage(String packageName) {
        return null;
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        return null;
    }

    public Process getProcess(String processId) {
        return null;
    }

    public Rule getRule(String packageName, String ruleName) {
        return null;
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        return this.newStatefulKnowledgeSession(null, null);
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession(KnowledgeSessionConfiguration conf, Environment environment) {
        String kresultsId = "kresults_" + this.serviceManager.getSessionId();
        String localId = UUID.randomUUID().toString();
        Message msg = new Message(this.serviceManager.getSessionId(), this.serviceManager.counter.incrementAndGet(), false, null, new SetVariableCommand("__TEMP__", localId, (Command)new KnowledgeContextResolveFromContextCommand((Command)new NewStatefulKnowledgeSessionCommand(null), null, this.instanceId, null, kresultsId)));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.serviceManager.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.serviceManager.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (!(object instanceof FinishedCommand)) {
                throw new RuntimeException("Response was not correctly ended");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
        return new StatefulKnowledgeSessionClient(localId, this.serviceManager);
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KnowledgeSessionConfiguration conf) {
        return null;
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        return null;
    }

    public void removeKnowledgePackage(String packageName) {
    }

    public void removeProcess(String processId) {
    }

    public void removeRule(String packageName, String ruleName) {
    }

    public void addEventListener(KnowledgeBaseEventListener listener) {
    }

    public Collection<KnowledgeBaseEventListener> getKnowledgeBaseEventListeners() {
        return null;
    }

    public void removeEventListener(KnowledgeBaseEventListener listener) {
    }
}

