/*
 * Decompiled with CFR 0.152.
 */
package org.drools.vsm;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.transport.socket.SocketConnector;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseProvider;
import org.drools.agent.KnowledgeAgentProvider;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderProvider;
import org.drools.command.Command;
import org.drools.command.FinishedCommand;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.vsm.LookupCommand;
import org.drools.command.vsm.RegisterCommand;
import org.drools.command.vsm.ServiceManagerClientConnectCommand;
import org.drools.persistence.jpa.JPAKnowledgeServiceProvider;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.Environment;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.vsm.BaseMinaClient;
import org.drools.vsm.BaseMinaHandler;
import org.drools.vsm.KnowledgeBaseProviderClient;
import org.drools.vsm.KnowledgeBuilderProviderClient;
import org.drools.vsm.Message;
import org.drools.vsm.ServiceManager;
import org.drools.vsm.StatefulKnowledgeSessionClient;
import org.drools.vsm.responsehandlers.BlockingMessageResponseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerClient
implements ServiceManager {
    public BaseMinaClient client;
    public AtomicInteger counter;
    private int sessionId;

    public ServiceManagerClient(String name, BaseMinaHandler handler) {
        this.client = new BaseMinaClient(name, handler);
        this.counter = new AtomicInteger();
    }

    public boolean connect(SocketConnector connector, SocketAddress address) {
        boolean connected = this.client.connect(connector, address);
        if (connected) {
            Message msg = new Message(-1, this.counter.incrementAndGet(), false, null, new ServiceManagerClientConnectCommand());
            BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
            this.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.client.session.write((Object)msg);
            this.sessionId = (Integer)handler.getMessage().getPayload();
        }
        return connected;
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public KnowledgeBuilderProvider getKnowledgeBuilderFactory() {
        return new KnowledgeBuilderProviderClient(this);
    }

    public KnowledgeBaseProvider getKnowledgeBaseFactory() {
        return new KnowledgeBaseProviderClient(this);
    }

    public KnowledgeAgentProvider getKnowledgeAgentFactory() {
        return null;
    }

    public JPAKnowledgeServiceProvider JPAKnowledgeService() {
        return null;
    }

    public Environment getEnvironment() {
        return null;
    }

    public Collection<String> list() {
        return null;
    }

    public void register(String identifier, CommandExecutor executor) {
        String commandId = "client.lookup" + this.getNextId();
        String kresultsId = "kresults_" + this.getSessionId();
        if (!(executor instanceof StatefulKnowledgeSession)) {
            throw new IllegalArgumentException("Type is not supported for registration");
        }
        int type = 0;
        Message msg = new Message(this.getSessionId(), this.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new RegisterCommand(identifier, ((StatefulKnowledgeSessionClient)executor).getInstanceId(), type), null, null, null, null));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (!(object instanceof FinishedCommand)) {
                throw new RuntimeException("Response was not correctly ended");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public CommandExecutor lookup(String identifier) {
        String commandId = "client.lookup" + this.getNextId();
        String kresultsId = "kresults_" + this.getSessionId();
        Message msg = new Message(this.getSessionId(), this.counter.incrementAndGet(), false, null, new KnowledgeContextResolveFromContextCommand((Command)new LookupCommand(identifier, commandId), null, null, null, kresultsId));
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        try {
            this.client.handler.addResponseHandler(msg.getResponseId(), handler);
            this.client.session.write((Object)msg);
            Object object = handler.getMessage().getPayload();
            if (object == null) {
                throw new RuntimeException("Response was not correctly received");
            }
            String value = (String)((ExecutionResults)object).getValue(commandId);
            String type = String.valueOf(value.charAt(0));
            String instanceId = value.substring(2);
            StatefulKnowledgeSessionClient executor = null;
            switch (Integer.parseInt(type)) {
                case 0: {
                    executor = new StatefulKnowledgeSessionClient(instanceId, this);
                    break;
                }
            }
            return executor;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute message", e);
        }
    }

    public void release(Object object) {
    }

    public void release(String identifier) {
    }

    public void send(Command command) {
        this.client.session.write((Object)command);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getNextId() {
        return this.counter.incrementAndGet();
    }

    public static class RemoveKnowledgeBuilderProvider
    implements KnowledgeBuilderProvider {
        public DecisionTableConfiguration newDecisionTableConfiguration() {
            return null;
        }

        public KnowledgeBuilder newKnowledgeBuilder() {
            return null;
        }

        public KnowledgeBuilder newKnowledgeBuilder(KnowledgeBuilderConfiguration conf) {
            return null;
        }

        public KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase) {
            return null;
        }

        public KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase, KnowledgeBuilderConfiguration conf) {
            return null;
        }

        public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
            return null;
        }

        public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(Properties properties, ClassLoader classLoader) {
            return null;
        }
    }
}

