/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.backend.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.packages.PackageNameParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameWriter;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.datamodel.packages.HasPackageName;
import org.drools.workbench.screens.drltext.model.DrlModelContent;
import org.drools.workbench.screens.drltext.service.DRLTextEditorService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DRLTextEditorServiceImpl
implements DRLTextEditorService {
    private static final JavaFileFilter FILTER_JAVA = new JavaFileFilter();
    private static final DirectoryStream.Filter<Path> FILTER_DRLS = new FileExtensionFilter(".drl");
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ProjectService projectService;
    @Inject
    private GenericValidator genericValidator;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        try {
            String drl = this.assertPackageName(content, context);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            this.ioService.createFile(nioPath, new FileAttribute[0]);
            this.ioService.write(nioPath, drl, new OpenOption[]{this.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public DrlModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            String drl = this.load(path);
            ProjectDataModelOracle oracle = this.dataModelService.getProjectDataModel(path);
            String[] fullyQualifiedClassNames = DataModelOracleUtilities.getFactTypes((ProjectDataModelOracle)oracle);
            return new DrlModelContent(drl, Arrays.asList(fullyQualifiedClassNames));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<String> loadClassFields(org.uberfire.backend.vfs.Path path, String fullyQualifiedClassName) {
        try {
            ProjectDataModelOracle oracle = this.dataModelService.getProjectDataModel(path);
            String[] fieldNames = DataModelOracleUtilities.getFieldNames((ProjectDataModelOracle)oracle, (String)fullyQualifiedClassName);
            return Arrays.asList(fieldNames);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        try {
            String drl = this.assertPackageName(content, resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), drl, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(this.sessionInfo, this.projectService.resolveProject(resource), resource));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, String content) {
        try {
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(content.getBytes()), new DirectoryStream.Filter[]{FILTER_JAVA, FILTER_DRLS});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String assertPackageName(String drl, org.uberfire.backend.vfs.Path resource) {
        try {
            String existingPackageName = PackageNameParser.parsePackageName((String)drl);
            if (!"".equals(existingPackageName)) {
                return drl;
            }
            Package pkg = this.projectService.resolvePackage(resource);
            final String requiredPackageName = pkg == null ? null : pkg.getPackageName();
            HasPackageName mockHasPackageName = new HasPackageName(){

                public String getPackageName() {
                    return requiredPackageName;
                }

                public void setPackageName(String packageName) {
                }
            };
            StringBuilder sb = new StringBuilder();
            PackageNameWriter.write((StringBuilder)sb, (HasPackageName)mockHasPackageName);
            sb.append(drl);
            return sb.toString();
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

