/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.backend.server.indexing;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.drltext.type.DSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.PackageDescrIndexVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.uberfire.metadata.engine.Indexer;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;

@ApplicationScoped
public class DslrFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(DslrFileIndexer.class);
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ProjectService projectService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private DSLRResourceTypeDefinition dslrType;

    public boolean supportsPath(Path path) {
        return this.dslrType.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String dslr = this.ioService.readAllString(path);
            Expander expander = this.getDSLExpander(path);
            String drl = expander.expand(dslr);
            DrlParser drlParser = new DrlParser();
            PackageDescr packageDescr = drlParser.parse(true, drl);
            if (packageDescr == null) {
                logger.error("Unable to parse DRL for '" + path.toUri().toString() + "'.");
                return index;
            }
            ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
            Project project = this.projectService.resolveProject(Paths.convert((Path)path));
            Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
            DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg);
            PackageDescrIndexVisitor visitor = new PackageDescrIndexVisitor(dmo, builder, packageDescr);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }

    private Expander getDSLExpander(Path path) {
        DefaultExpander expander = new DefaultExpander();
        List<DSLMappingFile> dsls = this.getDSLMappingFiles(path);
        for (DSLMappingFile dsl : dsls) {
            expander.addDSLMapping(dsl.getMapping());
        }
        return expander;
    }

    private List<DSLMappingFile> getDSLMappingFiles(Path path) {
        ArrayList<DSLMappingFile> dsls = new ArrayList<DSLMappingFile>();
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(vfsPath).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            DSLTokenizedMappingFile dslFile = new DSLTokenizedMappingFile();
            try {
                if (dslFile.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                    dsls.add((DSLMappingFile)dslFile);
                    continue;
                }
                logger.error("Unable to parse DSL definition: " + dslDefinition);
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
        }
        return dsls;
    }
}

