/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.drltext.backend.server.indexing;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.workbench.screens.drltext.type.DSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.kie.soup.project.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.drools.AbstractDrlFileIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DslrFileIndexer
extends AbstractDrlFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(DslrFileIndexer.class);
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    @Inject
    private DataModelService dataModelService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private DSLRResourceTypeDefinition dslrType;

    public boolean supportsPath(Path path) {
        return this.dslrType.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        String dslr = this.ioService.readAllString(path);
        Expander expander = this.getDSLExpander(path);
        String drl = expander.expand(dslr);
        return this.fillDrlIndexBuilder(path, drl);
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }

    private Expander getDSLExpander(Path path) {
        DefaultExpander expander = new DefaultExpander();
        List<DSLMappingFile> dsls = this.getDSLMappingFiles(path);
        for (DSLMappingFile dsl : dsls) {
            expander.addDSLMapping(dsl.getMapping());
        }
        return expander;
    }

    private List<DSLMappingFile> getDSLMappingFiles(Path path) {
        ArrayList<DSLMappingFile> dsls = new ArrayList<DSLMappingFile>();
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(vfsPath).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            DSLTokenizedMappingFile dslFile = new DSLTokenizedMappingFile();
            try {
                if (dslFile.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                    dsls.add((DSLMappingFile)dslFile);
                    continue;
                }
                logger.error("Unable to parse DSL definition: " + dslDefinition);
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
        }
        return dsls;
    }
}

