/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.compiler.lang.dsl.DSLMapping;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.dsltext.type.DSLResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.drools.AbstractDrlFileIndexer;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DslFileIndexer
extends AbstractDrlFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDrlFileIndexer.class);
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected DSLResourceTypeDefinition dslType;
    public static final String MOCK_RULE_NAME = DslFileIndexer.class.getSimpleName() + "_parsing_dummy_rule";

    public boolean supportsPath(Path path) {
        return this.dslType.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        ArrayList<String> lhs = new ArrayList<String>();
        ArrayList<String> rhs = new ArrayList<String>();
        DSLTokenizedMappingFile dslLoader = new DSLTokenizedMappingFile();
        String dsl = this.ioService.readAllString(path);
        if (dslLoader.parseAndLoad((Reader)new StringReader(dsl))) {
            DSLMapping dslMapping = dslLoader.getMapping();
            for (DSLMappingEntry e : dslMapping.getEntries()) {
                switch (e.getSection()) {
                    case CONDITION: {
                        lhs.add(e.getValuePattern());
                        break;
                    }
                    case CONSEQUENCE: {
                        rhs.add(e.getValuePattern());
                        break;
                    }
                }
            }
            String drl = this.makeDrl(path, lhs, rhs);
            return this.fillDrlIndexBuilder(path, drl);
        }
        return null;
    }

    protected DefaultIndexBuilder getIndexBuilder(Path path) {
        Project project = this.projectService.resolveProject(Paths.convert((Path)path));
        if (project == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": project could not be resolved.");
            return null;
        }
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(project, pkg){

            public DefaultIndexBuilder addGenerator(IndexElementsGenerator generator) {
                if (generator instanceof Resource && ((Resource)generator).getResourceFQN().endsWith(MOCK_RULE_NAME)) {
                    return this;
                }
                return super.addGenerator(generator);
            }
        };
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }

    private String makeDrl(Path path, List<String> lhs, List<String> rhs) {
        StringBuilder sb = new StringBuilder();
        String packageName = this.getPackageName(path);
        sb.append("package ").append(packageName).append("\n");
        sb.append("rule \"" + MOCK_RULE_NAME + "\"\n");
        sb.append("when\n");
        for (String e : lhs) {
            sb.append(e).append("\n");
        }
        sb.append("then\n");
        for (String e : rhs) {
            sb.append(e).append("\n");
        }
        sb.append("end\n");
        String drl = sb.toString();
        return drl.replaceAll("\\{.*\\}", "0");
    }
}

