/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.editor;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Well;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.dtablexls.client.editor.DecisionTableXLSEditorView;
import org.drools.workbench.screens.dtablexls.client.editor.URLHelper;
import org.drools.workbench.screens.dtablexls.client.resources.DecisionTableXLSResources;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public class DecisionTableXLSEditorViewImpl
extends KieEditorViewImpl
implements DecisionTableXLSEditorView {
    private AttachmentFileWidget uploadWidget;
    private final Button downloadButton = new Button(DecisionTableXLSEditorConstants.INSTANCE.Download());
    private final VerticalPanel layout = new VerticalPanel();
    private final FormStyleLayout formStyleLayout = new FormStyleLayout(this.getIcon(), DecisionTableXLSEditorConstants.INSTANCE.DecisionTable());
    @Inject
    private Event<NotificationEvent> notificationEvent;
    @Inject
    private DecisionTableXLSResourceType resourceType;
    private DecisionTableXLSEditorView.Presenter presenter;
    private ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;

    @PostConstruct
    public void init() {
        this.uploadWidget = new AttachmentFileWidget(new String[]{this.resourceType.getSuffix()}, true);
        this.layout.setWidth("100%");
        this.layout.add((Widget)this.formStyleLayout);
        this.initWidget((Widget)this.layout);
        this.setWidth("100%");
    }

    public void init(DecisionTableXLSEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setConcurrentUpdateSessionInfo(ObservablePath.OnConcurrentUpdateEvent eventInfo) {
        this.concurrentUpdateSessionInfo = eventInfo;
    }

    @Override
    public void setPath(final Path path) {
        Well uploadWell = new Well();
        HorizontalPanel uploadContainer = new HorizontalPanel();
        uploadContainer.add((Widget)new Label(DecisionTableXLSEditorConstants.INSTANCE.UploadNewVersion() + ":"));
        uploadContainer.add((Widget)this.uploadWidget);
        uploadWell.add((Widget)uploadContainer);
        this.formStyleLayout.addRow((Widget)uploadWell);
        this.uploadWidget.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BusyPopup.showMessage((String)DecisionTableXLSEditorConstants.INSTANCE.Uploading());
                if (DecisionTableXLSEditorViewImpl.this.concurrentUpdateSessionInfo != null) {
                    ConcurrentChangePopup.newConcurrentUpdate((Path)DecisionTableXLSEditorViewImpl.this.concurrentUpdateSessionInfo.getPath(), (User)DecisionTableXLSEditorViewImpl.this.concurrentUpdateSessionInfo.getIdentity(), (Command)new Command(){

                        public void execute() {
                            DecisionTableXLSEditorViewImpl.this.submit(path);
                        }
                    }, (Command)new Command(){

                        public void execute() {
                        }
                    }, (Command)new Command(){

                        public void execute() {
                            DecisionTableXLSEditorViewImpl.this.presenter.reload();
                            DecisionTableXLSEditorViewImpl.this.concurrentUpdateSessionInfo = null;
                        }
                    }).show();
                } else {
                    DecisionTableXLSEditorViewImpl.this.submit(path);
                }
            }
        });
        Well downloadWell = new Well();
        HorizontalPanel downloadContainer = new HorizontalPanel();
        downloadContainer.add((Widget)new Label(DecisionTableXLSEditorConstants.INSTANCE.DownloadCurrentVersion() + ":"));
        downloadContainer.add((Widget)this.downloadButton);
        downloadWell.add((Widget)downloadContainer);
        this.formStyleLayout.addRow((Widget)downloadWell);
        this.downloadButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.open((String)URLHelper.getDownloadUrl(path), (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
            }
        });
    }

    private void submit(Path path) {
        this.uploadWidget.submit(path, URLHelper.getServletUrl(), new com.google.gwt.user.client.Command(){

            public void execute() {
                BusyPopup.close();
                DecisionTableXLSEditorViewImpl.this.notifySuccess();
            }
        }, new com.google.gwt.user.client.Command(){

            public void execute() {
                BusyPopup.close();
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.uploadWidget.setEnabled(!isReadOnly);
    }

    private Image getIcon() {
        Image image = new Image(DecisionTableXLSResources.INSTANCE.images().decisionTableIconLarge());
        image.setAltText(DecisionTableXLSEditorConstants.INSTANCE.DecisionTable());
        return image;
    }

    private void notifySuccess() {
        this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCreatedSuccessfully()));
    }
}

