/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.workbench.screens.globals.client.resources.i18n.GlobalsEditorConstants;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class AddGlobalPopup
extends BaseModal {
    private static AddGlobalPopupBinder uiBinder = (AddGlobalPopupBinder)GWT.create(AddGlobalPopupBinder.class);
    @UiField
    FormGroup aliasGroup;
    @UiField
    TextBox aliasTextBox;
    @UiField
    HelpBlock aliasHelpInline;
    @UiField
    FormGroup classNameGroup;
    @UiField
    ListBox classNameListBox;
    @UiField
    HelpBlock classNameHelpInline;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            AddGlobalPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            AddGlobalPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public AddGlobalPopup() {
        this.setTitle(GlobalsEditorConstants.INSTANCE.addGlobalPopupTitle());
        this.add((Widget)new ModalBody(){
            {
                this.add((Widget)uiBinder.createAndBindUi((Object)AddGlobalPopup.this));
            }
        });
        this.add((Widget)this.footer);
        this.aliasTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                AddGlobalPopup.this.aliasGroup.setValidationState(ValidationState.NONE);
                AddGlobalPopup.this.aliasHelpInline.setText("");
            }
        });
    }

    private void onOKButtonClick() {
        boolean hasError = false;
        if (this.aliasTextBox.getText() == null || this.aliasTextBox.getText().trim().isEmpty()) {
            this.aliasGroup.setValidationState(ValidationState.ERROR);
            this.aliasHelpInline.setText(GlobalsEditorConstants.INSTANCE.aliasIsMandatory());
            hasError = true;
        } else {
            this.aliasGroup.setValidationState(ValidationState.NONE);
        }
        if (this.classNameListBox.getSelectedIndex() < 0) {
            this.classNameGroup.setValidationState(ValidationState.ERROR);
            this.classNameHelpInline.setText(GlobalsEditorConstants.INSTANCE.classNameIsMandatory());
            hasError = true;
        } else {
            this.classNameGroup.setValidationState(ValidationState.NONE);
        }
        if (hasError) {
            return;
        }
        if (this.callbackCommand != null) {
            this.callbackCommand.execute();
        }
        this.hide();
    }

    public String getAlias() {
        return this.aliasTextBox.getText();
    }

    public String getClassName() {
        return this.classNameListBox.getSelectedValue();
    }

    public void setContent(Command callbackCommand, List<String> fullyQualifiedClassNames) {
        this.callbackCommand = callbackCommand;
        this.classNameListBox.clear();
        this.aliasTextBox.setText("");
        for (String className : fullyQualifiedClassNames) {
            this.classNameListBox.addItem(className);
        }
    }

    static interface AddGlobalPopupBinder
    extends UiBinder<Widget, AddGlobalPopup> {
    }
}

