/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.client.type.GlobalResourceType;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@WorkbenchEditor(identifier="org.kie.guvnor.globals", supportedTypes={GlobalResourceType.class}, priority=101)
public class GlobalsEditorPresenter
extends KieEditor {
    @Inject
    private Caller<GlobalsEditorService> globalsEditorService;
    private GlobalsEditorView view;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private ValidationPopup validationPopup;
    @Inject
    private GlobalResourceType type;
    private GlobalsModel model;

    public GlobalsEditorPresenter() {
    }

    @Inject
    public GlobalsEditorPresenter(GlobalsEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((GlobalsEditorService)this.globalsEditorService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<GlobalsEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<GlobalsEditorContent>(){

            public void callback(GlobalsEditorContent content) {
                if (GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                GlobalsEditorPresenter.this.model = content.getModel();
                GlobalsEditorPresenter.this.resetEditorPages(content.getOverview());
                GlobalsEditorPresenter.this.addSourcePage();
                List fullyQualifiedClassNames = content.getFullyQualifiedClassNames();
                GlobalsEditorPresenter.this.view.setContent(content.getModel().getGlobals(), fullyQualifiedClassNames, GlobalsEditorPresenter.this.isReadOnly);
                GlobalsEditorPresenter.this.createOriginalHash(GlobalsEditorPresenter.this.model);
                GlobalsEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((GlobalsEditorService)GlobalsEditorPresenter.this.globalsEditorService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            GlobalsEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            GlobalsEditorPresenter.this.validationPopup.showMessages(results);
                        }
                    }
                })).validate((Path)GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)GlobalsEditorPresenter.this.model);
            }
        };
    }

    protected void save(String commitMessage) {
        ((GlobalsEditorService)this.globalsEditorService.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, this.metadata, commitMessage);
    }

    public void onSourceTabSelected() {
        ((GlobalsEditorService)this.globalsEditorService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GlobalsEditorPresenter.this.updateSource(source);
            }
        })).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

