/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.client.type.GlobalResourceType;
import org.drools.workbench.screens.globals.model.GlobalsEditorContent;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@WorkbenchEditor(identifier="org.kie.guvnor.globals", supportedTypes={GlobalResourceType.class}, priority=101)
public class GlobalsEditorPresenter
extends KieEditor {
    @Inject
    protected Caller<GlobalsEditorService> globalsEditorService;
    @Inject
    protected Caller<ValidationService> validationService;
    @Inject
    protected ValidationPopup validationPopup;
    private GlobalsEditorView view;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private GlobalResourceType type;
    private GlobalsModel model;

    public GlobalsEditorPresenter() {
    }

    @Inject
    public GlobalsEditorPresenter(GlobalsEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
    }

    protected void makeMenuBar() {
        this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> ((GlobalsEditorPresenter)this).onSave())).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.fileNameValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.fileNameValidator).addDelete(this::onDelete).addValidate(this.onValidate()).addNewTopLevelMenu(this.versionRecordManager.buildMenu());
    }

    protected void loadContent() {
        this.view.showLoading();
        ((GlobalsEditorService)this.globalsEditorService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    protected RemoteCallback<GlobalsEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<GlobalsEditorContent>(){

            public void callback(GlobalsEditorContent content) {
                if (GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                GlobalsEditorPresenter.this.model = content.getModel();
                GlobalsEditorPresenter.this.resetEditorPages(content.getOverview());
                GlobalsEditorPresenter.this.addSourcePage();
                List fullyQualifiedClassNames = content.getFullyQualifiedClassNames();
                GlobalsEditorPresenter.this.view.setContent(content.getModel().getGlobals(), fullyQualifiedClassNames, GlobalsEditorPresenter.this.isReadOnly, content.getOverview().getMetadata().isGenerated());
                GlobalsEditorPresenter.this.createOriginalHash(GlobalsEditorPresenter.this.model);
                GlobalsEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((GlobalsEditorService)GlobalsEditorPresenter.this.globalsEditorService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            GlobalsEditorPresenter.this.notification.fire((Object)new NotificationEvent(org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            GlobalsEditorPresenter.this.validationPopup.showMessages(results);
                        }
                    }
                })).validate((Path)GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)GlobalsEditorPresenter.this.model);
            }
        };
    }

    protected void save() {
        ((ValidationService)this.validationService.call(validationMessages -> {
            if (((List)validationMessages).isEmpty()) {
                this.showSavePopup();
            } else {
                this.validationPopup.showSaveValidationMessages(() -> this.showSavePopup(), () -> {}, (List)validationMessages);
            }
        })).validateForSave((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
        this.concurrentUpdateSessionInfo = null;
    }

    private void showSavePopup() {
        this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                GlobalsEditorPresenter.this.baseView.showSaving();
                ((GlobalsEditorService)GlobalsEditorPresenter.this.globalsEditorService.call(GlobalsEditorPresenter.this.getSaveSuccessCallback(GlobalsEditorPresenter.this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)GlobalsEditorPresenter.this.view))).save((Path)GlobalsEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)GlobalsEditorPresenter.this.model, GlobalsEditorPresenter.this.metadata, commitMessage);
                GlobalsEditorPresenter.this.concurrentUpdateSessionInfo = null;
            }
        });
    }

    protected void onDelete() {
        ((ValidationService)this.validationService.call(validationMessages -> {
            if (((List)validationMessages).isEmpty()) {
                this.showDeletePopup((Path)this.getVersionRecordManager().getCurrentPath());
            } else {
                this.validationPopup.showDeleteValidationMessages(() -> this.showDeletePopup((Path)this.versionRecordManager.getCurrentPath()), () -> {}, (List)validationMessages);
            }
        })).validateForDelete((Path)this.versionRecordManager.getCurrentPath());
    }

    private void showDeletePopup(Path path) {
        this.deletePopUpPresenter.show(comment -> {
            this.view.showBusyIndicator(org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants.INSTANCE.Deleting());
            ((GlobalsEditorService)this.globalsEditorService.call(this.getDeleteSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).delete(path, "delete");
        });
    }

    private RemoteCallback<Path> getDeleteSuccessCallback() {
        return response -> {
            this.view.hideBusyIndicator();
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
        };
    }

    public void onSourceTabSelected() {
        ((GlobalsEditorService)this.globalsEditorService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                GlobalsEditorPresenter.this.updateSource(source);
            }
        })).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

