/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.screens.globals.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

/**
 * Globals Editor I18N constants
 */
public interface GlobalsEditorConstants {

    @TranslationKey(defaultValue = "")
    String AddGlobalPopupTitle = "AddGlobalPopup.Title";

    @TranslationKey(defaultValue = "")
    String AddGlobalPopupAliasInputPlaceholder = "AddGlobalPopup.AliasInputPlaceholder";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplAutoGeneratedFile = "GlobalsEditorViewImpl.AutoGeneratedFile";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplNoGlobalsDefined = "GlobalsEditorViewImpl.NoGlobalsDefined";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplAlias = "GlobalsEditorViewImpl.Alias";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplClassName = "GlobalsEditorViewImpl.ClassName";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplAdd = "GlobalsEditorViewImpl.Add";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplRemove = "GlobalsEditorViewImpl.Remove";

    @TranslationKey(defaultValue = "")
    String GlobalsEditorViewImplPromptForRemovalOfGlobal = "GlobalsEditorViewImpl.PromptForRemovalOfGlobal";

    @TranslationKey(defaultValue = "")
    String GlobalResourceTypeDescription = "GlobalResourceType.Description";

    @TranslationKey(defaultValue = "")
    String NewGlobalHandlerNewGlobalDescription = "NewGlobalHandler.NewGlobalDescription";
}
