/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopupView;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
@Templated
public class AddGlobalPopupViewImpl
implements AddGlobalPopupView {
    @DataField(value="view")
    Div view;
    @DataField(value="aliasFormGroup")
    Element aliasFormGroup = DOM.createSpan();
    @DataField(value="aliasInput")
    TextInput aliasInput;
    @DataField(value="aliasInputHelp")
    Element aliasInputHelp = DOM.createSpan();
    @DataField(value="classNameFormGroup")
    Element classNameFormGroup = DOM.createSpan();
    @DataField(value="classNameSelect")
    Select classNameSelect;
    @DataField(value="classNameSelectHelp")
    Element classNameSelectHelp = DOM.createSpan();
    @DataField(value="addButton")
    Button addButton;
    @DataField(value="cancelButton")
    Button cancelButton;
    private AddGlobalPopupView.Presenter presenter;
    private BaseModal modal;
    private TranslationService translationService;

    @Inject
    public AddGlobalPopupViewImpl(Div view, TextInput aliasInput, Select classNameSelect, Button yesButton, Button cancelButton, TranslationService translationService) {
        this.view = view;
        this.aliasInput = aliasInput;
        this.classNameSelect = classNameSelect;
        this.addButton = yesButton;
        this.cancelButton = cancelButton;
        this.translationService = translationService;
        aliasInput.setAttribute("placeholder", translationService.getTranslation("AddGlobalPopup.AliasInputPlaceholder"));
    }

    public void init(AddGlobalPopupView.Presenter presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    @Override
    public void setClassNames(List<String> classNames) {
        for (String className : classNames) {
            Option option = new Option();
            option.setText(className);
            option.setValue(className);
            this.classNameSelect.add((Widget)option);
        }
        this.classNameSelect.refresh();
    }

    @Override
    public String getInsertedAlias() {
        return this.aliasInput.getValue();
    }

    @Override
    public String getSelectedClassName() {
        Option selectedItem = this.classNameSelect.getSelectedItem();
        return selectedItem != null ? selectedItem.getValue() : null;
    }

    @Override
    public void hideAliasValidationError() {
        this.aliasInputHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        StyleHelper.addUniqueEnumStyleName((Element)this.aliasFormGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void showAliasValidationError() {
        this.aliasInputHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        StyleHelper.addUniqueEnumStyleName((Element)this.aliasFormGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void hideClassNameValidationError() {
        this.classNameSelectHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        StyleHelper.addUniqueEnumStyleName((Element)this.classNameFormGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void showClassNameValidationError() {
        this.classNameSelectHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        StyleHelper.addUniqueEnumStyleName((Element)this.classNameFormGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void clear() {
        this.hideAliasValidationError();
        this.hideClassNameValidationError();
        this.aliasInput.setValue("");
        this.classNameSelect.clear();
    }

    @Override
    public void show() {
        this.modal = new BaseModal();
        this.modal.setTitle(this.translationService.getTranslation("AddGlobalPopup.Title"));
        this.modal.setBody((Widget)ElementWrapperWidget.getWidget((HTMLElement)this.view));
        this.modal.show();
    }

    @Override
    public void hide() {
        if (this.modal != null) {
            this.modal.hide();
        }
    }

    @EventHandler(value={"aliasInput"})
    public void aliasInputChanged(ChangeEvent changeEvent) {
        this.presenter.onAliasInputChanged();
    }

    @EventHandler(value={"classNameSelect"})
    public void classNameSelectChanged(ChangeEvent changeEvent) {
        this.presenter.onClassNameSelectChanged();
    }

    @EventHandler(value={"addButton"})
    public void addButtonClicked(ClickEvent clickEvent) {
        this.presenter.onAddButtonClicked();
    }

    @EventHandler(value={"cancelButton"})
    public void cancelButtonClicked(ClickEvent clickEvent) {
        this.presenter.onCancelButtonClicked();
    }
}

