/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.dtree.backend.GuidedDecisionTreeXMLPersistence;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.guvnor.common.services.backend.file.CopyHelper;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.type.FileNameUtil;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class GuidedDecisionTreeEditorCopyHelper
implements CopyHelper {
    @Inject
    private GuidedDTreeResourceTypeDefinition resourceType;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public boolean supports(org.uberfire.backend.vfs.Path destination) {
        return this.resourceType.accept(destination);
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        Path _destination = Paths.convert((org.uberfire.backend.vfs.Path)destination);
        String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)destination));
        GuidedDecisionTree model = GuidedDecisionTreeXMLPersistence.getInstance().unmarshal(content);
        String treeName = FileNameUtil.removeExtension((org.uberfire.backend.vfs.Path)destination, (ResourceTypeDefinition)this.resourceType);
        model.setTreeName(treeName);
        this.ioService.write(_destination, GuidedDecisionTreeXMLPersistence.getInstance().marshal(model), new OpenOption[]{this.makeCommentedOption("File [" + source.toURI() + "] copied to [" + destination.toURI() + "].")});
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

