/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.uberfire.commons.validation.PortablePreconditions;

public class GuidedDecisionTreeModelVisitor {
    private final GuidedDecisionTree model;
    private final String packageName;
    private final Imports imports;

    public GuidedDecisionTreeModelVisitor(GuidedDecisionTree model) {
        this.model = (GuidedDecisionTree)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.packageName = model.getPackageName();
        this.imports = model.getImports();
    }

    public Set<String> getConsumedModelClasses() {
        HashSet factTypes = new HashSet();
        HashSet<String> fullyQualifiedClassNames = new HashSet<String>();
        for (String factType : factTypes) {
            fullyQualifiedClassNames.add(this.convertToFullyQualifiedClassName(factType));
        }
        return fullyQualifiedClassNames;
    }

    private String convertToFullyQualifiedClassName(String factType) {
        if (factType.contains(".")) {
            return factType;
        }
        String fullyQualifiedClassName = null;
        for (Import imp : this.imports.getImports()) {
            if (!imp.getType().endsWith(factType)) continue;
            fullyQualifiedClassName = imp.getType();
            break;
        }
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.packageName + "." + factType;
        }
        return fullyQualifiedClassName;
    }
}

