/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server.indexing;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.dtree.backend.GuidedDecisionTreeXMLPersistence;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.screens.guided.dtree.backend.server.indexing.GuidedDecisionTreeModelIndexVisitor;
import org.drools.workbench.screens.guided.dtree.type.GuidedDTreeResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.uberfire.metadata.engine.Indexer;
import org.kie.uberfire.metadata.model.KObject;
import org.kie.uberfire.metadata.model.KObjectKey;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedDecisionTreeFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(GuidedDecisionTreeFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected GuidedDTreeResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String content = this.ioService.readAllString(path);
            GuidedDecisionTree model = GuidedDecisionTreeXMLPersistence.getInstance().unmarshal(content);
            Project project = this.projectService.resolveProject(Paths.convert((Path)path));
            Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
            DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg);
            GuidedDecisionTreeModelIndexVisitor visitor = new GuidedDecisionTreeModelIndexVisitor(builder, model);
            visitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }
}

